/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.TernarySearchTree;

public class TSTSearchEngine<E>
implements SearchEngine<E> {
    private final TernarySearchTree<String> tst = new TernarySearchTree();
    private final Map<String, List<E>> map = new HashMap<String, List<E>>();

    public TSTSearchEngine(List<E> sources) {
        for (E source : sources) {
            this.put(source);
        }
    }

    public TSTSearchEngine() {
    }

    @Override
    public List<E> searchAll(String prefix) {
        String mapKey = prefix.toUpperCase();
        List<String> keys = this.tst.matchPrefix(mapKey);
        ArrayList list = new ArrayList();
        for (String key : keys) {
            list.addAll(this.map.get(key));
        }
        return list;
    }

    @Override
    public E search(String prefix) {
        String mapKey = prefix.toUpperCase();
        List<String> keys = this.tst.matchPrefix(mapKey);
        if (!keys.isEmpty()) {
            String key = keys.get(0);
            List<E> l = this.map.get(key);
            return !l.isEmpty() ? (E)l.get(0) : null;
        }
        return null;
    }

    public final void put(E value) {
        String mapKey = value.toString().toUpperCase();
        this.tst.put(mapKey, mapKey);
        List<E> list = this.map.get(mapKey);
        if (list == null) {
            list = new ArrayList();
            this.map.put(mapKey, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    public void remove(E value) {
        String mapKey = value.toString().toUpperCase();
        List<E> list = this.map.get(mapKey);
        if (list == null) {
            return;
        }
        list.remove(value);
        if (list.isEmpty()) {
            this.tst.remove(mapKey);
            this.map.remove(mapKey);
        }
    }
}

