/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.XPath;
import java.io.IOException;

public class XPathException
extends Exception {
    private Throwable cause_ = null;

    public XPathException(XPath xPath, String string) {
        super(xPath + " " + string);
    }

    XPathException(XPath xPath, String string, SimpleStreamTokenizer simpleStreamTokenizer, String string2) {
        this(xPath, string + " got \"" + XPathException.toString(simpleStreamTokenizer) + "\" instead of expected " + string2);
    }

    XPathException(XPath xPath, Exception exception) {
        super(xPath + " " + exception);
        this.cause_ = exception;
    }

    public Throwable getCause() {
        return this.cause_;
    }

    private static String toString(SimpleStreamTokenizer simpleStreamTokenizer) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(XPathException.tokenToString(simpleStreamTokenizer));
            if (simpleStreamTokenizer.ttype != -1) {
                simpleStreamTokenizer.nextToken();
                stringBuffer.append(XPathException.tokenToString(simpleStreamTokenizer));
                simpleStreamTokenizer.pushBack();
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return "(cannot get  info: " + iOException + ")";
        }
    }

    private static String tokenToString(SimpleStreamTokenizer simpleStreamTokenizer) {
        switch (simpleStreamTokenizer.ttype) {
            case -1: {
                return "<end of expression>";
            }
            case -2: {
                return simpleStreamTokenizer.nval + "";
            }
            case -3: {
                return simpleStreamTokenizer.sval;
            }
        }
        return (char)simpleStreamTokenizer.ttype + "";
    }
}

