/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.audio;

import java.io.IOException;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.audio.AudioException;
import org.openstreetmap.josm.io.audio.AudioListener;
import org.openstreetmap.josm.io.audio.JavaFxMediaPlayer;
import org.openstreetmap.josm.io.audio.JavaSoundPlayer;
import org.openstreetmap.josm.io.audio.SoundPlayer;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class AudioPlayer
extends Thread
implements AudioListener {
    private static volatile AudioPlayer audioPlayer;
    private State state = State.INITIALIZING;
    private SoundPlayer soundPlayer;
    private URL playingUrl = null;
    private final Execute command = new Execute();

    public static void play(URL uRL) throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.play(uRL, 0.0, 1.0);
        }
    }

    public static void play(URL uRL, double d) throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.play(uRL, d, 1.0);
        }
    }

    public static void play(URL uRL, double d, double d2) throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.play(uRL, d, d2);
        }
    }

    public static void pause() throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.pause();
        }
    }

    public static URL url() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? null : audioPlayer.playingUrl;
    }

    public static boolean paused() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? false : audioPlayer.state == State.PAUSED;
    }

    public static boolean playing() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? false : audioPlayer.state == State.PLAYING;
    }

    public static double position() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? -1.0 : audioPlayer.soundPlayer.position();
    }

    public static double speed() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? -1.0 : audioPlayer.soundPlayer.speed();
    }

    private static AudioPlayer getInstance() {
        if (audioPlayer != null) {
            return audioPlayer;
        }
        try {
            audioPlayer = new AudioPlayer();
            return audioPlayer;
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
            Main.error(runtimeException);
            return null;
        }
    }

    public static void reset() {
        if (audioPlayer != null) {
            try {
                AudioPlayer.pause();
            }
            catch (IOException | InterruptedException exception) {
                Main.warn(exception);
            }
            AudioPlayer.audioPlayer.playingUrl = null;
        }
    }

    private AudioPlayer() {
        double d = Main.pref.getDouble("audio.leadin", 1.0);
        double d2 = Main.pref.getDouble("audio.calibration", 1.0);
        try {
            this.soundPlayer = new JavaFxMediaPlayer();
        }
        catch (InterruptedException | NoClassDefFoundError throwable) {
            Main.debug(throwable);
            Main.warn("Java FX is unavailable. Falling back to Java Sound API");
            this.soundPlayer = new JavaSoundPlayer(d, d2);
        }
        this.soundPlayer.addAudioListener(this);
        this.start();
        while (this.state == State.INITIALIZING) {
            AudioPlayer.yield();
        }
    }

    @Override
    public void run() {
        this.playingUrl = null;
        while (true) {
            try {
                while (true) {
                    switch (this.state) {
                        case INITIALIZING: {
                            this.state = State.NOTPLAYING;
                            break;
                        }
                        case NOTPLAYING: 
                        case PAUSED: {
                            AudioPlayer.sleep(200L);
                            break;
                        }
                        case PLAYING: {
                            this.command.possiblyInterrupt();
                            if (this.soundPlayer.playing(this.command)) {
                                this.playingUrl = null;
                                this.state = State.NOTPLAYING;
                            }
                            this.command.possiblyInterrupt();
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                AudioPlayer.interrupted();
                State state = this.state;
                this.state = State.INTERRUPTED;
                try {
                    switch (this.command.command()) {
                        case PLAY: {
                            this.soundPlayer.play(this.command, state, this.playingUrl);
                            state = State.PLAYING;
                            break;
                        }
                        case PAUSE: {
                            this.soundPlayer.pause(this.command, state, this.playingUrl);
                            state = State.PAUSED;
                            break;
                        }
                    }
                    this.command.ok(state);
                }
                catch (IOException | IllegalArgumentException | SecurityException | AudioException exception) {
                    Main.error(exception);
                    this.command.failed(exception);
                }
                continue;
            }
            catch (IOException | AudioException exception) {
                this.state = State.NOTPLAYING;
                Main.error(exception);
                continue;
            }
            break;
        }
    }

    @Override
    public void playing(URL uRL) {
        this.playingUrl = uRL;
    }

    class Execute {
        private Command command;
        private Result result;
        private Exception exception;
        private URL url;
        private double offset;
        private double speed;

        Execute() {
        }

        protected void play(URL uRL, double d, double d2) throws InterruptedException, IOException {
            this.url = uRL;
            this.offset = d;
            this.speed = d2;
            this.command = Command.PLAY;
            this.result = Result.WAITING;
            this.send();
        }

        protected void pause() throws InterruptedException, IOException {
            this.command = Command.PAUSE;
            this.send();
        }

        private void send() throws InterruptedException, IOException {
            this.result = Result.WAITING;
            AudioPlayer.this.interrupt();
            while (this.result == Result.WAITING) {
                Thread.sleep(10L);
            }
            if (this.result == Result.FAILED) {
                throw new IOException(this.exception);
            }
        }

        protected void possiblyInterrupt() throws InterruptedException {
            if (Thread.interrupted() || this.result == Result.WAITING) {
                throw new InterruptedException();
            }
        }

        protected void failed(Exception exception) {
            this.exception = exception;
            this.result = Result.FAILED;
            AudioPlayer.this.state = State.NOTPLAYING;
        }

        protected void ok(State state) {
            this.result = Result.OK;
            AudioPlayer.this.state = state;
        }

        protected double offset() {
            return this.offset;
        }

        protected double speed() {
            return this.speed;
        }

        protected URL url() {
            return this.url;
        }

        protected Command command() {
            return this.command;
        }
    }

    static enum Result {
        WAITING,
        OK,
        FAILED;

    }

    static enum Command {
        PLAY,
        PAUSE;

    }

    static enum State {
        INITIALIZING,
        NOTPLAYING,
        PLAYING,
        PAUSED,
        INTERRUPTED;

    }
}

