/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddSelectionToRelations
extends AbstractRelationAction
implements SelectionChangedListener {
    public AddSelectionToRelations() {
        this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyendright"));
        this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last member", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Relation relation : this.relations) {
            Command command = GenericRelationEditor.addPrimitivesToRelation(relation, Main.getLayerManager().getEditDataSet().getSelected());
            if (command == null) continue;
            linkedList.add(command);
        }
        if (!linkedList.isEmpty()) {
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Add selection to relation", new Object[0]), linkedList));
            new Notification("<html>" + I18n.tr("{0}Add selection to relation{1}: Verify every single relation to avoid damage!", "<strong>", "</strong>") + "</html>").setIcon(2).show();
        }
    }

    @Override
    public void updateEnabledState() {
        this.putValue("Name", I18n.trn("Add selection to {0} relation", "Add selection to {0} relations", this.relations.size(), this.relations.size()));
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        GuiHelper.runInEDT(() -> this.setEnabled(collection != null && !collection.isEmpty()));
    }
}

