/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jmeld.util.prefs.Preference;

public class ComboBoxSelectionPreference
extends Preference {
    private static String SELECTED_ITEM = "SELECTED_ITEM";
    private JComboBox target;
    private int maxItems = 10;

    public ComboBoxSelectionPreference(String preferenceName, JComboBox target) {
        super("ComboBox-" + preferenceName);
        this.target = target;
        this.init();
    }

    private void init() {
        String selectedItem = this.getString(SELECTED_ITEM, null);
        this.target.getModel().addListDataListener(this.getListDataListener());
        if (this.target.getItemCount() > 0) {
            int selectedIndex = 0;
            if (selectedItem != null) {
                for (int i = 0; i < this.target.getItemCount(); ++i) {
                    Object object = this.target.getItemAt(i);
                    if (object == null || !object.toString().equals(selectedItem)) continue;
                    selectedIndex = i;
                    break;
                }
            }
            this.target.setSelectedIndex(selectedIndex);
        }
    }

    private void save() {
        ComboBoxModel model = this.target.getModel();
        Object item = model.getSelectedItem();
        if (item != null) {
            this.putString(SELECTED_ITEM, item.toString());
        }
    }

    private ListDataListener getListDataListener() {
        return new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                ComboBoxSelectionPreference.this.save();
            }

            public void intervalAdded(ListDataEvent e) {
                ComboBoxSelectionPreference.this.save();
            }

            public void intervalRemoved(ListDataEvent e) {
                ComboBoxSelectionPreference.this.save();
            }
        };
    }
}

