/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import net.sourceforge.napkinlaf.NapkinRootPaneUI;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.borders.NapkinLineBorder;
import net.sourceforge.napkinlaf.borders.NapkinWrappedBorder;
import net.sourceforge.napkinlaf.util.NapkinBackground;

public class NapkinTitlePane
extends JComponent {
    private static final Border EMPTY_BORDER = new NapkinWrappedBorder(new EmptyBorder(0, 0, 0, 0));
    private static final int IMAGE_HEIGHT = 18;
    private static final int IMAGE_WIDTH = 18;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private final JRootPane rootPane;
    private int state;

    public NapkinTitlePane(JRootPane root) {
        this.rootPane = root;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.propertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener propertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
        this.setBorder(new NapkinLineBorder(false));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            NapkinTitlePane.addMenuItems(menu);
        }
        return menu;
    }

    private static void addMenuItems(JMenu menu) {
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            // empty if block
        }
        menu.add(new JSeparator());
    }

    private JButton createTitleButton(Action action) {
        JButton button = new JButton(action){

            public void setBorder(Border value) {
                super.setBorder(this.getIcon() == null ? new NapkinBoxBorder() : EMPTY_BORDER);
            }
        };
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton(this.closeAction);
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.setText(null);
        this.closeButton.setBorder(EMPTY_BORDER);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = null;
            this.minimizeIcon = null;
            this.iconifyButton = this.createTitleButton(this.iconifyAction);
            this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
            this.iconifyButton.setText(null);
            this.iconifyButton.setBorder(EMPTY_BORDER);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
            this.toggleButton = this.createTitleButton(this.restoreAction);
            this.toggleButton.setIcon(this.maximizeIcon);
            this.toggleButton.setText(null);
            this.toggleButton.setSize(18, 18);
            this.toggleButton.setBorder(new NapkinBoxBorder());
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", activeB);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                if ((state & 6) != 0 && (this.rootPane.getBorder() == null || this.rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    this.rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    NapkinRootPaneUI.installBorder(this.rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        String theTitle;
        int xOffset;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean leftToRight = this.window == null ? this.rootPane.getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.window == null || this.window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Color foreground = isSelected ? theme.getSelectionColor() : theme.getPenColor();
        NapkinBackground bg = theme.getPaper();
        Rectangle bounds = this.getBounds();
        Insets insets = this.getInsets();
        bounds.x -= insets.left;
        bounds.width += insets.left + insets.right;
        bounds.y -= insets.top;
        bounds.width += insets.top + insets.bottom;
        bg.paint(this, g, bounds, bounds, insets);
        int n = xOffset = leftToRight ? 5 : width - 5;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += leftToRight ? 23 : -23;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = g.getFontMetrics();
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0 && this.window != null) {
                    rect.x = this.window.getWidth() - this.window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = NapkinTitlePane.clipStringIfNecessary(fm, theTitle, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = NapkinTitlePane.clipStringIfNecessary(fm, theTitle, titleW);
                xOffset -= fm.stringWidth(theTitle);
            }
            int titleLength = fm.stringWidth(theTitle);
            g.drawString(theTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    private static String clipStringIfNecessary(FontMetrics fm, String text, int width) {
        int textWidth = fm.stringWidth(text);
        String result = text;
        for (int len = text.length(); len > 0 && textWidth > width; --len) {
            result = text.substring(0, len) + "...";
            textWidth = fm.stringWidth(result);
        }
        return result;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            NapkinTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            NapkinTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = NapkinTitlePane.this.getFrame();
                if (frame != null) {
                    NapkinTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    NapkinTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                NapkinTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name) || "iconImage".equals(name)) {
                NapkinTitlePane.this.revalidate();
                NapkinTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = NapkinTitlePane.this.rootPane.getFontMetrics(NapkinTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (NapkinTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 18;
            }
            return Math.max(fontHeight, iconHeight);
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = NapkinTitlePane.this.window == null ? NapkinTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : NapkinTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = NapkinTitlePane.this.getWidth();
            if (NapkinTitlePane.this.closeButton != null && NapkinTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = NapkinTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = NapkinTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 18;
                buttonWidth = 18;
            }
            int spacing = 5;
            int x = leftToRight ? spacing : w - buttonWidth - spacing;
            int y = 3;
            if (NapkinTitlePane.this.menuBar != null) {
                NapkinTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (NapkinTitlePane.this.closeButton != null) {
                NapkinTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (NapkinTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && NapkinTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 10;
                    NapkinTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (NapkinTitlePane.this.iconifyButton != null && NapkinTitlePane.this.iconifyButton.getParent() != null) {
                    spacing = 2;
                    NapkinTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        public void paint(Graphics g) {
            Image image;
            Frame frame = NapkinTitlePane.this.getFrame();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                g.drawImage(image, 0, 0, 18, 18, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(18, size.width), Math.max(size.height, 18));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        MaximizeAction() {
            super("Maximize");
        }

        public void actionPerformed(ActionEvent e) {
            NapkinTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        RestoreAction() {
            super("Restore");
        }

        public void actionPerformed(ActionEvent e) {
            NapkinTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        IconifyAction() {
            super("Minimize");
        }

        public void actionPerformed(ActionEvent e) {
            NapkinTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            NapkinTitlePane.this.close();
        }
    }
}

