/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.cache.CacheEntry;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityResultSet;
import unity.operators.Operator;
import unity.parser.GlobalParser;
import unity.query.Evaluator;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LimitInfo;
import unity.query.LocalQuery;
import unity.query.Optimizer;
import unity.util.StringFunc;

public class UnityStatement
implements Statement {
    private UnityConnection unityconn = null;
    private int _resultSetType = 0;
    private int _resultSetConcurrency = 0;
    private ResultSet _results = null;
    private ResultSet _nextResults = null;
    private ResultSet _generatedKeys = null;
    private SQLWarning _warnings = null;
    private int _timeout = 0;
    private int _maxFieldSize = 0;
    private int _maxRows = 0;
    private long _updateCount = -1L;
    private int _fetchSize = 100;
    private boolean _closed = false;
    private boolean localExecution = false;
    private CacheEntry entry;
    private GlobalSchema schema;
    private long sortBufferSize;
    private long joinBufferSize;
    private HashMap<String, String> properties;

    public UnityStatement(UnityConnection unityConnection, int n, int n2, GlobalSchema globalSchema, long l, long l2) {
        this.unityconn = unityConnection;
        this._resultSetType = n;
        this._resultSetConcurrency = n2;
        this.schema = globalSchema;
        this.sortBufferSize = l;
        this.joinBufferSize = l2;
    }

    public long getSortBufferSize() {
        return this.sortBufferSize;
    }

    public void setSortBufferSize(long l) {
        this.sortBufferSize = l;
    }

    public long getJoinBufferSize() {
        return this.joinBufferSize;
    }

    public void setJoinBufferSize(long l) {
        this.joinBufferSize = l;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this._closed) {
            if (this._results != null) {
                this._results.close();
            }
            this._closed = true;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select")) {
            this._results = this.executeQuery(string);
            return true;
        }
        if (string.toLowerCase().trim().startsWith("explain")) {
            this._results = this.executeExplain(string);
            return true;
        }
        this._updateCount = this.executeUpdate(string);
        return false;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, 0, Integer.MAX_VALUE);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select") || string.toLowerCase().trim().startsWith("explain")) {
            throw new SQLException(UnityDriver.i18n.getString("Statement.ErrorSELECTExecuteUpdate") + string);
        }
        String string2 = string + ';';
        GlobalParser globalParser = new GlobalParser(false, true);
        GlobalUpdate globalUpdate = globalParser.parseUpdate(string2, this.schema);
        globalUpdate.setStatement(string2);
        Evaluator evaluator = new Evaluator(globalUpdate);
        return evaluator.executeUpdate(this.unityconn, this);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.unityconn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._generatedKeys;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this._results != null) {
            this._results.close();
        }
        this._results = this._nextResults;
        this._nextResults = null;
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._timeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._results;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this._updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n <= 0 || n > this._maxRows) {
            throw new SQLException(UnityDriver.i18n.getString("Statement.InvalidFetchSize") + n);
        }
        this._fetchSize = n;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this._maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this._maxRows = n;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this._timeout = n;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    public ResultSet executeExplain(String string) throws SQLException {
        String string2 = string.substring(8) + ";";
        GlobalQuery globalQuery = this.parseQuery(string2);
        int n = 12;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "id", 4, "INTEGER", 0, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "parentId", 4, "INTEGER", 0, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "operation", 12, "VARCHAR", 30, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "source", 12, "VARCHAR", 30, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "rows", -5, "BIGINT", 0, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "rowSize", -5, "BIGINT", 0, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "iobytes", -5, "BIGINT", 0, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "cost", -5, "BIGINT", 0, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "percentCost", 12, "VARCHAR", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "totalcost", -5, "BIGINT", 0, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "percentTotal", 12, "VARCHAR", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "description", 12, "VARCHAR", 500, 0, 0, 0, "", null, 0, 12, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        Operator operator = globalQuery.getExecutionTree();
        globalQuery.getLogicalQueryTree().getRoot().calculateCosts();
        double d = this.computeTotalCost(operator);
        this.explainOutput(arrayList2, n, operator, 1, 0, d);
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    private double computeTotalCost(Operator operator) {
        if (operator == null) {
            return 0.0;
        }
        double d = operator.getCost();
        for (int i = 0; i < operator.numChildren(); ++i) {
            d += this.computeTotalCost(operator.getChild(i));
        }
        return d;
    }

    private double explainOutput(ArrayList<ArrayList<Object>> arrayList, int n, Operator operator, int n2, int n3, double d) {
        if (operator == null) {
            return 0.0;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        arrayList2.add(arrayList.size() + 1);
        arrayList2.add(n3);
        arrayList2.add(operator.getName());
        arrayList2.add(operator.getSource());
        arrayList2.add(operator.getRows());
        arrayList2.add(operator.getRowSize());
        arrayList2.add(Math.round(operator.getIO()));
        double d2 = operator.getCost();
        arrayList2.add(Math.round(d2));
        arrayList2.add(decimalFormat.format(100.0 * d2 / d) + "%");
        arrayList2.add(0);
        arrayList2.add(0);
        arrayList2.add(StringFunc.spaces((n2 - 1) * 3) + operator.getDescription());
        arrayList.add(arrayList2);
        double d3 = d2;
        for (int i = 0; i < operator.numChildren(); ++i) {
            d3 += this.explainOutput(arrayList, n, operator.getChild(i), n2 + 1, (Integer)arrayList2.get(0), d);
        }
        arrayList2.set(9, Math.round(d3));
        arrayList2.set(10, decimalFormat.format(100.0 * d3 / d) + "%");
        return d3;
    }

    public ResultSet executeQuery(String string, int n, int n2) throws SQLException {
        String string2;
        int n3 = n2;
        if (this._maxRows > 0 && this._maxRows < n3) {
            n3 = this._maxRows;
        }
        if (this._results != null) {
            this._results.close();
        }
        String string3 = string;
        LimitInfo limitInfo = LimitInfo.parse(string3);
        if (!(limitInfo.hasLimit || n == 0 && n3 == Integer.MAX_VALUE)) {
            limitInfo.rowCount = n3;
            limitInfo.hasLimit = true;
            if (n != 0) {
                limitInfo.hasOffset = true;
                limitInfo.startRow = n;
            }
            string3 = StringFunc.replaceLimit(string3, limitInfo);
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Executing query:\n" + string3);
        }
        if (!(string2 = string3.toLowerCase().trim()).startsWith("select") && !string2.trim().startsWith("#np")) {
            if (string2.startsWith("explain")) {
                return this.executeExplain(string3);
            }
            if (string2.startsWith("translate")) {
                return UnityDriver.translate(string3);
            }
            throw new SQLException(UnityDriver.i18n.getString("Statement.ErrorSELECTExecuteQuery") + string3);
        }
        string3 = StringFunc.verifyTerminator(string3);
        this.entry = null;
        if (this.unityconn.getCacheType() > 0) {
            // empty if block
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Local execution is: " + this.localExecution);
        }
        try {
            GlobalParser globalParser = new GlobalParser(this.localExecution, true);
            GlobalQuery globalQuery = globalParser.parse(string3, this.schema);
            globalQuery.setConnection(this.unityconn);
            globalQuery.setQueryString(string3);
            Optimizer optimizer = new Optimizer(globalQuery, this.localExecution, this);
            globalQuery = optimizer.optimize();
            Evaluator evaluator = new Evaluator(globalQuery);
            UnityResultSet unityResultSet = evaluator.execute(this, this.unityconn, this._resultSetType, this._resultSetConcurrency, n, n3);
            this._results = unityResultSet;
            return unityResultSet;
        }
        catch (Exception exception) {
            if (!(exception instanceof SQLException)) {
                System.out.println("Uncaught exception: " + exception);
                exception.printStackTrace(System.out);
            } else if (UnityDriver.DEBUG) {
                System.out.println(exception);
            }
            throw new SQLException(exception.toString());
        }
    }

    public ResultSet executeByPassQuery(String string, String string2) throws SQLException {
        AnnotatedSourceDatabase annotatedSourceDatabase = this.schema.getDB(string);
        if (annotatedSourceDatabase == null) {
            throw new SQLException(UnityDriver.i18n.getString("Statement.UnknownDatabaseForBypass") + string);
        }
        LocalQuery localQuery = new LocalQuery(annotatedSourceDatabase);
        localQuery.setResultSetType(this._resultSetType);
        localQuery.setResultSetConcurrency(this._resultSetConcurrency);
        localQuery.setSQLQueryString(string2);
        localQuery.execute(this.unityconn);
        return localQuery.getResultSet();
    }

    public int executeByPassUpdate(String string, String string2) throws SQLException {
        Connection connection = this.unityconn.getConnection(string);
        Statement statement = connection.createStatement();
        return statement.executeUpdate(string2);
    }

    public int executeByPassUpdate(String string, String string2, int n) throws SQLException {
        Connection connection = this.unityconn.getConnection(string);
        Statement statement = connection.createStatement();
        int n2 = statement.executeUpdate(string2, 1);
        this._generatedKeys = statement.getGeneratedKeys();
        return n2;
    }

    public GlobalQuery parseQuery(String string, boolean bl) throws SQLException {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = StringFunc.verifyTerminator(string);
        GlobalParser globalParser = new GlobalParser(this.localExecution, bl);
        GlobalQuery globalQuery = globalParser.parse(string2, this.schema);
        globalQuery.setConnection(this.unityconn);
        globalQuery.setQueryString(string2);
        Optimizer optimizer = new Optimizer(globalQuery, this.localExecution, this);
        globalQuery = optimizer.optimize();
        return globalQuery;
    }

    public GlobalQuery parseQuery(String string) throws SQLException {
        return this.parseQuery(string, true);
    }

    public ResultSet executeQuery(GlobalQuery globalQuery) throws SQLException {
        Evaluator evaluator = new Evaluator(globalQuery);
        globalQuery.setConnection(this.unityconn);
        UnityResultSet unityResultSet = evaluator.execute(this, this.unityconn, this._resultSetType, this._resultSetConcurrency, 0, Integer.MAX_VALUE);
        return unityResultSet;
    }

    public boolean getLocalExecution() {
        return this.localExecution;
    }

    public void setLocalExecution(boolean bl) {
        this.localExecution = bl;
    }

    public boolean cacheHit() {
        return this.entry != null;
    }

    public GlobalSchema getSchema() {
        return this.schema;
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, string2);
    }
}

