/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.MainPanelTransferHandler;
import org.fife.ui.TabbedPaneTransferHandler;

class TabbedPaneViewTransferHandler
extends TabbedPaneTransferHandler {
    private AbstractMainView mainView;

    public TabbedPaneViewTransferHandler(AbstractMainView mainView) {
        this.mainView = mainView;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return MainPanelTransferHandler.hasFileFlavor(flavors) || super.canImport(c, flavors);
    }

    public boolean importData(JComponent c, Transferable t) {
        return MainPanelTransferHandler.importDataImpl(this.mainView, c, t) || super.importData(c, t);
    }

    protected void selectTab(final JTabbedPane tabbedPane, final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container parent = tabbedPane.getParent();
                if (parent instanceof AbstractMainView) {
                    ((AbstractMainView)parent).setSelectedIndex(index);
                } else {
                    tabbedPane.setSelectedIndex(index);
                }
            }
        });
    }
}

