/*
 * Decompiled with CFR 0.152.
 */
package ghidra.language.data;

import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import java.util.List;

public final class DataLanguageHelper {
    public static final LanguageCompilerSpecPair getLanguage(LanguageService languageService, int pointerSize, boolean isBigEndian) throws LanguageNotFoundException {
        if (pointerSize != 16 && pointerSize != 32 && pointerSize != 64) {
            throw new LanguageNotFoundException("Unable to locate DATA language for pointer size:" + pointerSize);
        }
        Processor processor = Processor.findOrPossiblyCreateProcessor((String)"DATA");
        Endian endian = isBigEndian ? Endian.BIG : Endian.LITTLE;
        int size = 64;
        String variant = "default";
        CompilerSpecID compilerSpecID = new CompilerSpecID("pointer" + pointerSize);
        LanguageCompilerSpecQuery query = new LanguageCompilerSpecQuery(processor, endian, Integer.valueOf(size), variant, compilerSpecID);
        List pairs = languageService.getLanguageCompilerSpecPairs(query);
        if (pairs.size() > 0) {
            if (pairs.size() > 1) {
                throw new LanguageNotFoundException("Too many DATA languages");
            }
            LanguageCompilerSpecPair pair = (LanguageCompilerSpecPair)pairs.get(0);
            return new LanguageCompilerSpecPair(pair.languageID, pair.compilerSpecID);
        }
        throw new LanguageNotFoundException("Unable to locate DATA language");
    }
}

