/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class MappedLogicalBreakpoint
implements LogicalBreakpointInternal {
    private final Set<TraceBreakpointKind> kinds;
    private final long length;
    private final LogicalBreakpointInternal.ProgramBreakpoint progBreak;
    private final Map<Trace, LogicalBreakpointInternal.TraceBreakpointSet> traceBreaks = new HashMap<Trace, LogicalBreakpointInternal.TraceBreakpointSet>();
    private final Set<Trace> tracesView = Collections.unmodifiableSet(this.traceBreaks.keySet());

    protected MappedLogicalBreakpoint(Program program, Address progAddr, long length, Collection<TraceBreakpointKind> kinds) {
        this.length = length;
        this.kinds = Set.copyOf(kinds);
        this.progBreak = new LogicalBreakpointInternal.ProgramBreakpoint(program, progAddr, length, this.kinds);
    }

    public String toString() {
        return String.format("<%s prog=%s, traces=%s>", this.getClass().getSimpleName(), this.progBreak, this.traceBreaks.values());
    }

    protected boolean hasProgramBreakpoint() {
        return this.progBreak.getBookmark() != null;
    }

    @Override
    public boolean isEmpty() {
        if (!this.progBreak.isEmpty()) {
            return false;
        }
        for (LogicalBreakpointInternal.TraceBreakpointSet breaks : this.traceBreaks.values()) {
            if (breaks.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected TraceRecorder requireRecorder(DebuggerModelService modelService, Trace trace) {
        TraceRecorder recorder = modelService.getRecorder(trace);
        if (recorder == null) {
            throw new AssertionError((Object)"This trace is not live");
        }
        return recorder;
    }

    @Override
    public void enableForProgram() {
        this.progBreak.enable();
    }

    @Override
    public void disableForProgram() {
        this.progBreak.disable();
    }

    @Override
    public void deleteForProgram() {
        this.progBreak.deleteFromProgram();
    }

    @Override
    public CompletableFuture<Void> enableForTrace(Trace trace) {
        BreakpointActionSet actions = new BreakpointActionSet();
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        if (breaks == null) {
            return AsyncUtils.NIL;
        }
        breaks.planEnable(actions, this.length, this.kinds);
        return actions.execute();
    }

    @Override
    public CompletableFuture<Void> disableForTrace(Trace trace) {
        BreakpointActionSet actions = new BreakpointActionSet();
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        if (breaks == null) {
            return AsyncUtils.NIL;
        }
        breaks.planDisable(actions, this.length, this.kinds);
        return actions.execute();
    }

    @Override
    public CompletableFuture<Void> deleteForTrace(Trace trace) {
        BreakpointActionSet actions = new BreakpointActionSet();
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        if (breaks == null) {
            return AsyncUtils.NIL;
        }
        breaks.planDelete(actions, this.length, this.kinds);
        return actions.execute();
    }

    @Override
    public void planEnable(BreakpointActionSet actions, Trace trace) {
        if (trace != null) {
            LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
            if (breaks == null) {
                return;
            }
            breaks.planEnable(actions, this.length, this.kinds);
            return;
        }
        for (LogicalBreakpointInternal.TraceBreakpointSet breaks : this.traceBreaks.values()) {
            breaks.planEnable(actions, this.length, this.kinds);
        }
    }

    @Override
    public CompletableFuture<Void> enable() {
        this.progBreak.enable();
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planEnable(actions, null);
        return actions.execute();
    }

    @Override
    public void planDisable(BreakpointActionSet actions, Trace trace) {
        if (trace != null) {
            LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
            if (breaks == null) {
                return;
            }
            breaks.planDisable(actions, this.length, this.kinds);
            return;
        }
        for (LogicalBreakpointInternal.TraceBreakpointSet breaks : this.traceBreaks.values()) {
            breaks.planDisable(actions, this.length, this.kinds);
        }
    }

    @Override
    public CompletableFuture<Void> disable() {
        this.progBreak.disable();
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDisable(actions, null);
        return actions.execute();
    }

    @Override
    public void planDelete(BreakpointActionSet actions, Trace trace) {
        if (trace != null) {
            LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
            if (breaks == null) {
                return;
            }
            breaks.planDelete(actions, this.length, this.kinds);
            return;
        }
        for (LogicalBreakpointInternal.TraceBreakpointSet breaks : this.traceBreaks.values()) {
            breaks.planDelete(actions, this.length, this.kinds);
        }
    }

    @Override
    public CompletableFuture<Void> delete() {
        this.progBreak.deleteFromProgram();
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDelete(actions, null);
        return actions.execute();
    }

    @Override
    public Bookmark getProgramBookmark() {
        return this.progBreak.getBookmark();
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return this.progBreak.getLocation();
    }

    @Override
    public void setTraceAddress(TraceRecorder recorder, Address address) {
        this.traceBreaks.put(recorder.getTrace(), new LogicalBreakpointInternal.TraceBreakpointSet(recorder, address));
    }

    @Override
    public Set<TraceBreakpoint> getTraceBreakpoints() {
        HashSet<TraceBreakpoint> result = new HashSet<TraceBreakpoint>();
        for (LogicalBreakpointInternal.TraceBreakpointSet breaks : this.traceBreaks.values()) {
            result.addAll(breaks.getBreakpoints());
        }
        return result;
    }

    @Override
    public Set<TraceBreakpoint> getTraceBreakpoints(Trace trace) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        return breaks == null ? Set.of() : new HashSet<TraceBreakpoint>(breaks.getBreakpoints());
    }

    @Override
    public Set<Trace> getMappedTraces() {
        return this.tracesView;
    }

    @Override
    public Set<Trace> getParticipatingTraces() {
        HashSet<Trace> result = new HashSet<Trace>();
        for (LogicalBreakpointInternal.TraceBreakpointSet breaks : this.traceBreaks.values()) {
            if (breaks.isEmpty()) continue;
            result.add(breaks.getTrace());
        }
        return result;
    }

    @Override
    public Address getTraceAddress(Trace trace) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        if (breaks == null) {
            return null;
        }
        return breaks.getAddress();
    }

    @Override
    public DomainObject getDomainObject() {
        return this.progBreak.getProgram();
    }

    @Override
    public Address getAddress() {
        return this.progBreak.getLocation().getByteAddress();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Set<TraceBreakpointKind> getKinds() {
        return this.kinds;
    }

    @Override
    public LogicalBreakpoint.Enablement computeEnablementForProgram(Program program) {
        if (this.progBreak.getProgram() != program) {
            return LogicalBreakpoint.Enablement.NONE;
        }
        return this.computeEnablement();
    }

    @Override
    public LogicalBreakpoint.Enablement computeEnablementForTrace(Trace trace) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        LogicalBreakpoint.ProgramEnablement progEn = this.progBreak.computeEnablement();
        if (breaks == null) {
            return LogicalBreakpoint.TraceEnablement.MISSING.combineProgram(progEn);
        }
        return breaks.computeEnablement().combineProgram(progEn);
    }

    @Override
    public LogicalBreakpoint.Enablement computeEnablement() {
        LogicalBreakpointInternal.TraceBreakpointSet breaks;
        LogicalBreakpoint.TraceEnablement tEn;
        LogicalBreakpoint.ProgramEnablement progEn = this.progBreak.computeEnablement();
        LogicalBreakpoint.TraceEnablement traceEn = LogicalBreakpoint.TraceEnablement.NONE;
        Iterator<LogicalBreakpointInternal.TraceBreakpointSet> iterator = this.traceBreaks.values().iterator();
        while (iterator.hasNext() && (traceEn = traceEn.combine(tEn = (breaks = iterator.next()).computeEnablement())) != LogicalBreakpoint.TraceEnablement.MIXED) {
        }
        return progEn.combineTrace(traceEn);
    }

    @Override
    public boolean canMerge(Program program, Bookmark bookmark) {
        return this.progBreak.canMerge(program, bookmark);
    }

    @Override
    public boolean canMerge(TraceBreakpoint breakpoint) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(breakpoint.getTrace());
        if (breaks == null) {
            throw new AssertionError();
        }
        if (this.length != breakpoint.getLength()) {
            return false;
        }
        if (!Objects.equals(this.kinds, breakpoint.getKinds())) {
            return false;
        }
        return breaks.canMerge(breakpoint);
    }

    @Override
    public boolean trackBreakpoint(Bookmark bookmark) {
        return this.progBreak.add(bookmark);
    }

    @Override
    public boolean trackBreakpoint(TraceBreakpoint breakpoint) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(breakpoint.getTrace());
        return breaks.add(breakpoint);
    }

    @Override
    public boolean untrackBreakpoint(Program program, Bookmark bookmark) {
        assert (this.progBreak.getProgram() == program);
        return this.progBreak.remove(bookmark);
    }

    @Override
    public boolean untrackBreakpoint(TraceBreakpoint breakpoint) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(breakpoint.getTrace());
        if (breaks == null) {
            return false;
        }
        return breaks.remove(breakpoint);
    }

    public boolean appliesTo(Program program) {
        return this.progBreak.getProgram() == Objects.requireNonNull(program);
    }

    public boolean appliesTo(Trace trace) {
        LogicalBreakpointInternal.TraceBreakpointSet breaks = this.traceBreaks.get(Objects.requireNonNull(trace));
        return !breaks.isEmpty();
    }
}

