/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.EnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementColumn;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;

public class ObjectEnumeratedColumnTableModel<C extends ObjectsEnumeratedTableColumn<C, ? super R>, R>
extends AbstractSortedTableModel<R>
implements EnumeratedColumnTableModel<R> {
    private final List<R> modelData = new ArrayList<R>();
    private final String name;
    private C[] cols;

    public ObjectEnumeratedColumnTableModel(String name, C[] cols) {
        this.name = name;
        this.cols = cols;
    }

    public void setColumns(C[] cols) {
        this.cols = cols;
        this.fireTableStructureChanged();
    }

    public String getName() {
        return this.name;
    }

    public List<R> getModelData() {
        return this.modelData;
    }

    public List<C> defaultSortOrder() {
        return Collections.emptyList();
    }

    public int getRowCount() {
        return this.modelData.size();
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.modelData.size()) {
            return "";
        }
        return this.getColumnValueForRow(this.modelData.get(rowIndex), columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        R row = this.modelData.get(rowIndex);
        C col = this.cols[columnIndex];
        Class<String> cls = String.class;
        col.setValueOf(row, cls.cast(aValue));
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        R row = this.modelData.get(rowIndex);
        C col = this.cols[columnIndex];
        return col.isEditable(row);
    }

    public boolean isSortable(int columnIndex) {
        C col = this.cols[columnIndex];
        return col.isSortable();
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public String getColumnName(int column) {
        return this.cols[column].getHeader();
    }

    public Object getColumnValueForRow(R t, int columnIndex) {
        if (columnIndex >= this.cols.length) {
            return "";
        }
        return this.cols[columnIndex].getValueOf(t);
    }

    public void add(R row) {
        int rowIndex = this.modelData.size();
        this.modelData.add(row);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void addAll(Collection<R> c) {
        int startIndex = this.modelData.size();
        this.modelData.addAll(c);
        int endIndex = this.modelData.size() - 1;
        this.fireTableRowsInserted(startIndex, endIndex);
    }

    public void notifyUpdated(R row) {
        int rowIndex = this.modelData.indexOf(row);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public List<R> notifyUpdatedWith(Predicate<R> predicate) {
        int lastIndexUpdated = 0;
        ListIterator<R> rit = this.modelData.listIterator();
        ArrayList<R> updated = new ArrayList<R>();
        while (rit.hasNext()) {
            R row = rit.next();
            if (!predicate.test(row)) continue;
            lastIndexUpdated = rit.previousIndex();
            updated.add(row);
        }
        int size = updated.size();
        if (size != 0) {
            if (size == 1) {
                this.fireTableRowsUpdated(lastIndexUpdated, lastIndexUpdated);
            } else {
                this.fireTableDataChanged();
            }
        }
        return updated;
    }

    public void delete(R row) {
        int rowIndex = this.modelData.indexOf(row);
        this.modelData.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public List<R> deleteWith(Predicate<R> predicate) {
        int lastIndexRemoved = 0;
        ListIterator<R> rit = this.modelData.listIterator();
        ArrayList<R> removed = new ArrayList<R>();
        while (rit.hasNext()) {
            R row = rit.next();
            if (!predicate.test(row)) continue;
            lastIndexRemoved = rit.previousIndex();
            rit.remove();
            removed.add(row);
        }
        int size = removed.size();
        if (size != 0) {
            if (size == 1) {
                this.fireTableRowsDeleted(lastIndexRemoved, lastIndexRemoved);
            } else {
                this.fireTableDataChanged();
            }
        }
        return removed;
    }

    public R findFirst(Predicate<R> predicate) {
        for (R row : this.modelData) {
            if (!predicate.test(row)) continue;
            return row;
        }
        return null;
    }

    public void clear() {
        this.modelData.clear();
        this.fireTableDataChanged();
    }

    public R getRow(int index) {
        return this.modelData.get(index);
    }

    public void updateColumns(ObjectElementRow x) {
        List<String> keys = x.getKeys();
        this.cols = ObjectElementColumn.generateColumns(keys);
    }

    public void fireTableChanged(TableModelEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableChanged(e);
            return;
        }
        TableModelEvent e1 = e;
        SwingUtilities.invokeLater(() -> super.fireTableChanged(e1));
    }

    public class TableRowIterator
    implements EnumeratedColumnTableModel.RowIterator<R> {
        protected final ListIterator<R> it;
        protected int index;

        public TableRowIterator() {
            this.it = ObjectEnumeratedColumnTableModel.this.modelData.listIterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public R next() {
            this.index = this.it.nextIndex();
            return this.it.next();
        }

        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        public R previous() {
            this.index = this.it.previousIndex();
            return this.it.previous();
        }

        public int nextIndex() {
            return this.it.nextIndex();
        }

        public int previousIndex() {
            return this.it.previousIndex();
        }

        public void remove() {
            this.it.remove();
            ObjectEnumeratedColumnTableModel.this.fireTableRowsDeleted(this.index, this.index);
        }

        public void set(R e) {
            this.it.set(e);
            ObjectEnumeratedColumnTableModel.this.fireTableRowsUpdated(this.index, this.index);
        }

        public void notifyUpdated() {
            ObjectEnumeratedColumnTableModel.this.fireTableRowsUpdated(this.index, this.index);
        }

        public void add(R e) {
            this.it.add(e);
            int nextIndex = this.it.nextIndex();
            ObjectEnumeratedColumnTableModel.this.fireTableRowsInserted(nextIndex, nextIndex);
        }
    }

    public static interface ObjectsEnumeratedTableColumn<C, R> {
        public Object getValueOf(R var1);

        public String getHeader();

        default public void setValueOf(R row, Object value) {
            throw new UnsupportedOperationException("Cell is not editable");
        }

        default public boolean isEditable(R row) {
            return false;
        }

        default public boolean isSortable() {
            return true;
        }

        default public ColumnSortState.SortDirection defaultSortDirection() {
            return ColumnSortState.SortDirection.ASCENDING;
        }
    }
}

