/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public interface LocationTrackingSpec
extends ExtensionPoint {
    public static final Private PRIVATE = new Private();

    public static boolean changeIsCurrent(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates current) {
        if (space == null || space.getThread() != current.getThread()) {
            return false;
        }
        if (space.getFrameLevel() != current.getFrame().intValue()) {
            return false;
        }
        return range.getLifespan().contains((Comparable)current.getSnap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationTrackingSpec fromConfigName(String name) {
        Private private_ = PRIVATE;
        synchronized (private_) {
            return LocationTrackingSpec.PRIVATE.specsByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, LocationTrackingSpec> allSpecs() {
        Private private_ = PRIVATE;
        synchronized (private_) {
            return Map.copyOf(LocationTrackingSpec.PRIVATE.specsByName);
        }
    }

    public String getConfigName();

    public String getMenuName();

    public Icon getMenuIcon();

    public String computeTitle(DebuggerCoordinates var1);

    public Address computeTraceAddress(PluginTool var1, DebuggerCoordinates var2, long var3);

    public boolean affectedByRegisterChange(TraceAddressSpace var1, TraceAddressSnapRange var2, DebuggerCoordinates var3);

    public boolean affectedByStackChange(TraceStack var1, DebuggerCoordinates var2);

    public static class TrackingSpecConfigFieldCodec
    implements AutoConfigState.ConfigFieldCodec<LocationTrackingSpec> {
        public LocationTrackingSpec read(SaveState state, String name, LocationTrackingSpec current) {
            String specName = state.getString(name, null);
            return LocationTrackingSpec.fromConfigName(specName);
        }

        public void write(SaveState state, String name, LocationTrackingSpec value) {
            state.putString(name, value.getConfigName());
        }
    }

    public static class Private {
        private final Map<String, LocationTrackingSpec> specsByName = new TreeMap<String, LocationTrackingSpec>();
        private final ChangeListener classListener = this::classesChanged;

        private Private() {
            ClassSearcher.addChangeListener((ChangeListener)this.classListener);
        }

        private synchronized void classesChanged(ChangeEvent evt) {
            MiscellaneousUtils.collectUniqueInstances(LocationTrackingSpec.class, this.specsByName, LocationTrackingSpec::getConfigName);
        }
    }
}

