/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class DeletePrototypeOverrideAction
extends AbstractDecompilerAction {
    public DeletePrototypeOverrideAction() {
        super("Remove Signature Override");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRemoveOverride"));
        this.setPopupMenuData(new MenuData(new String[]{"Remove Signature Override"}, "Decompile"));
    }

    public static CodeSymbol getSymbol(Function func, ClangToken tokenAtCursor) {
        if (tokenAtCursor == null) {
            return null;
        }
        Address addr = tokenAtCursor.getMinAddress();
        if (addr == null) {
            return null;
        }
        Namespace overspace = HighFunction.findOverrideSpace((Function)func);
        if (overspace == null) {
            return null;
        }
        SymbolTable symtab = func.getProgram().getSymbolTable();
        SymbolIterator iter = symtab.getSymbols(overspace);
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!sym.getName().startsWith("prt") || !(sym instanceof CodeSymbol) || !sym.getAddress().equals((Object)addr)) continue;
            return (CodeSymbol)sym;
        }
        return null;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        return DeletePrototypeOverrideAction.getSymbol(function, context.getTokenAtCursor()) != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function func = context.getFunction();
        CodeSymbol sym = DeletePrototypeOverrideAction.getSymbol(func, context.getTokenAtCursor());
        Program program = func.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        int transaction = program.startTransaction("Remove Override Signature");
        boolean commit = true;
        if (!symtab.removeSymbolSpecial((Symbol)sym)) {
            commit = false;
            Msg.showError(((Object)((Object)this)).getClass(), (Component)context.getDecompilerPanel(), (String)"Removing Override Signature Failed", (Object)"Error removing override signature");
        }
        program.endTransaction(transaction, commit);
    }
}

