/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class RegisterTranslator {
    private static Comparator<Register> registerSizeComparator = new Comparator<Register>(){

        @Override
        public int compare(Register r1, Register r2) {
            return r2.getBitLength() - r1.getBitLength();
        }
    };
    private Language oldLang;
    private Language newLang;
    private HashMap<Integer, List<Register>> oldRegisterMap;
    private HashMap<Integer, List<Register>> newRegisterMap;

    public RegisterTranslator(Language oldLang, Language newLang) {
        this.oldLang = oldLang;
        this.newLang = newLang;
        this.oldRegisterMap = this.buildOffsetMap(oldLang.getRegisters());
        this.newRegisterMap = this.buildOffsetMap(newLang.getRegisters());
    }

    private HashMap<Integer, List<Register>> buildOffsetMap(List<Register> registers) {
        HashMap<Integer, List<Register>> offsetMap = new HashMap<Integer, List<Register>>();
        for (Register register : registers) {
            Address addr = register.getAddress();
            if (!addr.isRegisterAddress() || !register.getAddressSpace().getName().equalsIgnoreCase("register")) continue;
            Integer offset = (int)addr.getOffset();
            List<Register> registerList = offsetMap.get(offset);
            if (registerList == null) {
                registerList = new ArrayList<Register>();
                offsetMap.put(offset, registerList);
            }
            registerList.add(register);
        }
        for (List registerList : offsetMap.values()) {
            Collections.sort(registerList, registerSizeComparator);
        }
        return offsetMap;
    }

    public Register getOldRegister(int offset, int size) {
        List<Register> list = this.oldRegisterMap.get(offset);
        if (list != null) {
            if (size == 0) {
                return list.get(0);
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Register reg = list.get(i);
                if (reg.getMinimumByteSize() < size) continue;
                return reg;
            }
        }
        return null;
    }

    public Register getNewRegister(int offset, int size) {
        List<Register> list = this.newRegisterMap.get(offset);
        if (list != null) {
            if (size == 0) {
                return list.get(0);
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Register reg = list.get(i);
                if (reg.getMinimumByteSize() < size) continue;
                return reg;
            }
        }
        return null;
    }

    public Register getNewRegister(Register oldReg) {
        return this.newLang.getRegister(oldReg.getName());
    }

    public Register getOldRegister(Register newReg) {
        return this.oldLang.getRegister(newReg.getName());
    }

    public List<Register> getNewRegisters() {
        return this.newLang.getRegisters();
    }
}

