/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class ParamListStandard
implements ParamList {
    protected int numgroup;
    protected int pointermax;
    protected boolean thisbeforeret;
    protected int resourceTwoStart;
    protected ParamEntry[] entry;
    protected AddressSpace spacebase;

    private int findEntry(Address loc, int size) {
        for (int i = 0; i < this.entry.length; ++i) {
            if (this.entry[i].getMinSize() > size || this.entry[i].justifiedContain(loc, size) != 0) continue;
            return i;
        }
        return -1;
    }

    protected VariableStorage assignAddress(Program program, DataType tp, int[] status, boolean ishiddenret, boolean isindirect) {
        DataType baseType;
        if (tp == null) {
            tp = DataType.DEFAULT;
        }
        if ((baseType = tp) instanceof TypeDef) {
            baseType = ((TypeDef)baseType).getBaseDataType();
        }
        if (baseType instanceof VoidDataType) {
            return VariableStorage.VOID_STORAGE;
        }
        int sz = tp.getLength();
        if (sz == 0) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        for (ParamEntry element : this.entry) {
            DynamicVariableStorage store;
            int grp = element.getGroup();
            if (status[grp] < 0 || element.getType() != 8 && ParamEntry.getMetatype(tp) != element.getType()) continue;
            VarnodeData res = new VarnodeData();
            status[grp] = element.getAddrBySlot(status[grp], tp.getLength(), res);
            if (res.space == null) continue;
            if (element.isExclusion()) {
                int maxgrp = grp + element.getGroupSize();
                for (int j = grp; j < maxgrp; ++j) {
                    status[j] = -1;
                }
                if (element.isFloatExtended()) {
                    sz = element.getSize();
                }
            }
            try {
                if (res.space.getType() == 6) {
                    Varnode[] pieces = element.getJoinRecord();
                    store = new DynamicVariableStorage(program, false, pieces);
                } else {
                    Address addr = res.space.getAddress(res.offset);
                    store = ishiddenret ? new DynamicVariableStorage(program, AutoParameterType.RETURN_STORAGE_PTR, addr, sz) : (isindirect ? new DynamicVariableStorage(program, true, addr, sz) : new DynamicVariableStorage(program, false, addr, sz));
                }
            }
            catch (InvalidInputException e) {
                break;
            }
            return store;
        }
        if (ishiddenret) {
            return DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.RETURN_STORAGE_PTR);
        }
        return DynamicVariableStorage.getUnassignedDynamicStorage(isindirect);
    }

    @Override
    public void assignMap(Program prog, DataType[] proto, ArrayList<VariableStorage> res, boolean addAutoParams) {
        int i;
        int[] status = new int[this.numgroup];
        for (i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        if (addAutoParams && res.size() == 2) {
            ProgramBasedDataTypeManager dtm = prog.getDataTypeManager();
            Pointer pointer = dtm.getPointer(proto[0]);
            VariableStorage store = this.assignAddress(prog, pointer, status, true, false);
            res.set(1, store);
        }
        for (i = 1; i < proto.length; ++i) {
            VariableStorage store;
            if (this.pointermax != 0 && proto[i] != null && proto[i].getLength() > this.pointermax) {
                ProgramBasedDataTypeManager dtm = prog.getDataTypeManager();
                Pointer pointer = dtm.getPointer(proto[i]);
                store = this.assignAddress(prog, pointer, status, false, true);
            } else {
                store = this.assignAddress(prog, proto[i], status, false, false);
            }
            res.add(store);
        }
    }

    @Override
    public VariableStorage[] getPotentialRegisterStorage(Program prog) {
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        for (ParamEntry element : this.entry) {
            ParamEntry pe = element;
            if (!pe.isExclusion() || !pe.getSpace().isRegisterSpace()) continue;
            VariableStorage var = null;
            try {
                var = new VariableStorage(prog, pe.getSpace().getAddress(pe.getAddressBase()), pe.getSize());
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (var == null) continue;
            res.add(var);
        }
        VariableStorage[] arres = new VariableStorage[res.size()];
        res.toArray(arres);
        return arres;
    }

    @Override
    public void saveXml(StringBuilder buffer, boolean isInput) {
        buffer.append(isInput ? "<input" : "<output");
        if (this.pointermax != 0) {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"pointermax", (long)this.pointermax);
        }
        if (this.thisbeforeret) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"thisbeforeretpointer", (String)"yes");
        }
        if (isInput && this.resourceTwoStart == 0) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buffer, (String)"separatefloat", (boolean)false);
        }
        buffer.append(">\n");
        int curgroup = -1;
        for (ParamEntry el : this.entry) {
            if (!(curgroup < 0 || el.isGrouped() && el.getGroup() == curgroup)) {
                buffer.append("</group>\n");
                curgroup = -1;
            }
            if (el.isGrouped() && curgroup < 0) {
                buffer.append("<group>\n");
                curgroup = el.getGroup();
            }
            el.saveXml(buffer);
            buffer.append('\n');
        }
        if (curgroup >= 0) {
            buffer.append("</group>\n");
        }
        buffer.append(isInput ? "</input>" : "</output>");
    }

    private void parsePentry(XmlPullParser parser, CompilerSpec cspec, ArrayList<ParamEntry> pe, int groupid, boolean splitFloat, boolean grouped) throws XmlParseException {
        int maxgroup;
        ParamEntry pentry = new ParamEntry(groupid);
        pe.add(pentry);
        pentry.restoreXml(parser, cspec, pe, grouped);
        if (splitFloat) {
            if (pentry.getType() == 3) {
                if (this.resourceTwoStart >= 0) {
                    throw new XmlParseException("parameter list floating-point entries must come first");
                }
            } else if (this.resourceTwoStart < 0) {
                this.resourceTwoStart = groupid;
            }
        }
        if (pentry.getSpace().isStackSpace()) {
            this.spacebase = pentry.getSpace();
        }
        if ((maxgroup = pentry.getGroup() + pentry.getGroupSize()) > this.numgroup) {
            this.numgroup = maxgroup;
        }
    }

    private void parseGroup(XmlPullParser parser, CompilerSpec cspec, ArrayList<ParamEntry> pe, int groupid, boolean splitFloat) throws XmlParseException {
        XmlElement el = parser.start(new String[]{"group"});
        int basegroup = this.numgroup;
        int count = 0;
        while (parser.peek().isStart()) {
            this.parsePentry(parser, cspec, pe, basegroup, splitFloat, true);
            ++count;
            ParamEntry lastEntry = pe.get(pe.size() - 1);
            if (lastEntry.getSpace().getType() != 6) continue;
            throw new XmlParseException("<pentry> in the join space not allowed in <group> tag");
        }
        for (int i = 1; i < count; ++i) {
            ParamEntry curEntry = pe.get(pe.size() - 1 - i);
            int j = 0;
            while (j < i) {
                ParamEntry.orderWithinGroup(pe.get(pe.size() - 1 - j), curEntry);
                ++i;
            }
        }
        parser.end(el);
    }

    @Override
    public void restoreXml(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        XmlElement el;
        ArrayList<ParamEntry> pe = new ArrayList<ParamEntry>();
        this.numgroup = 0;
        this.spacebase = null;
        this.pointermax = 0;
        this.thisbeforeret = false;
        boolean splitFloat = true;
        XmlElement mainel = parser.start(new String[0]);
        String attribute = mainel.getAttribute("pointermax");
        if (attribute != null) {
            this.pointermax = SpecXmlUtils.decodeInt((String)attribute);
        }
        if ((attribute = mainel.getAttribute("thisbeforeretpointer")) != null) {
            this.thisbeforeret = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        if ((attribute = mainel.getAttribute("separatefloat")) != null) {
            splitFloat = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        int n = this.resourceTwoStart = splitFloat ? -1 : 0;
        while ((el = parser.peek()).isStart()) {
            if (el.getName().equals("pentry")) {
                this.parsePentry(parser, cspec, pe, this.numgroup, splitFloat, false);
                continue;
            }
            if (!el.getName().equals("group")) continue;
            this.parseGroup(parser, cspec, pe, this.numgroup, splitFloat);
        }
        for (ParamEntry curEntry : pe) {
            if (!curEntry.isNonOverlappingJoin() || curEntry.countJoinOverlap(pe) == 1) continue;
            throw new XmlParseException("pentry tag must be listed after all its overlaps");
        }
        parser.end(mainel);
        this.entry = new ParamEntry[pe.size()];
        pe.toArray(this.entry);
    }

    @Override
    public int getStackParameterAlignment() {
        for (ParamEntry pentry : this.entry) {
            if (!pentry.getSpace().isStackSpace()) continue;
            return pentry.getAlign();
        }
        return -1;
    }

    @Override
    public Long getStackParameterOffset() {
        for (ParamEntry element : this.entry) {
            ParamEntry pentry = element;
            if (pentry.isExclusion() || !pentry.getSpace().isStackSpace()) continue;
            long res = pentry.getAddressBase();
            if (pentry.isReverseStack()) {
                res += (long)pentry.getSize();
            }
            res = pentry.getSpace().truncateOffset(res);
            return res;
        }
        return null;
    }

    @Override
    public boolean possibleParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        if (loc == null) {
            return false;
        }
        int num = this.findEntry(loc, size);
        if (num == -1) {
            return false;
        }
        ParamEntry curentry = this.entry[num];
        res.slot = curentry.getSlot(loc, 0);
        res.slotsize = curentry.isExclusion() ? curentry.getGroupSize() : (size - 1) / curentry.getAlign() + 1;
        return true;
    }

    public boolean equals(Object obj) {
        ParamListStandard op2 = (ParamListStandard)obj;
        if (!SystemUtilities.isArrayEqual((Object[])this.entry, (Object[])op2.entry)) {
            return false;
        }
        if (this.numgroup != op2.numgroup || this.pointermax != op2.pointermax) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.spacebase, (Object)op2.spacebase)) {
            return false;
        }
        return this.thisbeforeret == op2.thisbeforeret;
    }

    public int hashCode() {
        int hash = this.numgroup;
        hash = 79 * hash + this.pointermax;
        hash = 79 * hash + (this.thisbeforeret ? 27 : 19);
        for (ParamEntry param : this.entry) {
            hash = 79 * hash + param.hashCode();
        }
        if (this.spacebase == null) {
            hash = 79 * hash + this.spacebase.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isThisBeforeRetPointer() {
        return this.thisbeforeret;
    }
}

