/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class Conv {
    public static final int BYTE_MASK = 255;
    public static final int SHORT_MASK = 65535;
    public static final long INT_MASK = 0xFFFFFFFFL;

    private Conv() {
    }

    public static short byteToShort(byte b) {
        return (short)(b & 0xFF);
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static long byteToLong(byte b) {
        return Conv.intToLong(b & 0xFF);
    }

    public static int shortToInt(short s) {
        return s & 0xFFFF;
    }

    public static long shortToLong(short s) {
        return Conv.intToLong(s & 0xFFFF);
    }

    public static long intToLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static String toString(byte[] array) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : array) {
            buffer.append((char)b);
        }
        return buffer.toString();
    }

    public static String toHexString(byte b) {
        return Conv.zeropad(Integer.toHexString(Conv.byteToInt(b)), 2);
    }

    public static String toHexString(short s) {
        return Conv.zeropad(Integer.toHexString(Conv.shortToInt(s)), 4);
    }

    public static String toHexString(int i) {
        return Conv.zeropad(Integer.toHexString(i), 8);
    }

    public static String toHexString(long l) {
        return Conv.zeropad(Long.toHexString(l), 16);
    }

    public static String zeropad(String s, int len) {
        if (s == null) {
            s = "";
        }
        StringBuffer buffer = new StringBuffer(s);
        int zerosNeeded = len - s.length();
        for (int i = 0; i < zerosNeeded; ++i) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        byte b = -56;
        System.out.println("b=" + b);
        System.out.println("(int)b=" + Conv.byteToInt(b));
        System.out.println(Conv.toHexString((byte)5));
        short s = -25536;
        System.out.println("s=" + s);
        System.out.println("(int)s=" + Conv.shortToInt(s));
        System.out.println(Conv.toHexString((short)5));
        int i = -1147483648;
        System.out.println("i=" + i);
        System.out.println("(long)i=" + Conv.intToLong(i));
        System.out.println(Conv.toHexString(5));
    }
}

