/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventFilter;
import agent.dbgeng.manager.cmd.DbgSetFilterArgumentCommand;
import agent.dbgeng.manager.cmd.DbgSetFilterCommandCommand;
import agent.dbgeng.manager.evt.AbstractDbgEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.evt.DbgInitialBreakpointEvent;
import agent.dbgeng.manager.evt.DbgInitialModuleLoadEvent;
import agent.dbgeng.manager.evt.DbgModuleLoadedEvent;
import agent.dbgeng.manager.evt.DbgModuleUnloadedEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.evt.DbgProcessExitedEvent;
import agent.dbgeng.manager.evt.DbgSystemErrorEvent;
import agent.dbgeng.manager.evt.DbgThreadCreatedEvent;
import agent.dbgeng.manager.evt.DbgThreadExitedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetEvent;
import agent.dbgeng.model.iface2.DbgModelTargetEventContainer;
import agent.dbgeng.model.iface2.DbgModelTargetEventOption;
import agent.dbgeng.model.impl.DbgModelTargetContinuationOptionImpl;
import agent.dbgeng.model.impl.DbgModelTargetExecutionOptionImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Event", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class DbgModelTargetEventImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetEvent {
    final String COMMAND_ATTRIBUTE_NAME = "Command";
    final String ARGUMENT_ATTRIBUTE_NAME = "Argument";
    final String CONTINUE_OPTION_ATTRIBUTE_NAME = "Continue";
    final String EXECUTE_OPTION_ATTRIBUTE_NAME = "Execute";
    protected DbgModelTargetEventOption execOption;
    protected DbgModelTargetEventOption contOption;
    private DbgEventFilter filter;

    protected static String indexFilter(DbgEventFilter filter) {
        return filter.getName();
    }

    protected static String keyFilter(DbgEventFilter filter) {
        return PathUtils.makeKey((String)DbgModelTargetEventImpl.indexFilter(filter));
    }

    public DbgModelTargetEventImpl(DbgModelTargetEventContainer events, DbgEventFilter filter) {
        super(events.getModel(), (TargetObject)events, DbgModelTargetEventImpl.keyFilter(filter), "EventFilter");
        this.getModel().addModelObject(filter, (TargetObject)this);
        this.filter = filter;
        DebugControl.DebugFilterExecutionOption exec = DebugControl.DebugFilterExecutionOption.getByNumber(filter.getExecutionOption());
        DebugControl.DebugFilterContinuationOption cont = DebugControl.DebugFilterContinuationOption.getByNumber(filter.getContinueOption());
        this.execOption = new DbgModelTargetExecutionOptionImpl(this, exec);
        this.contOption = new DbgModelTargetContinuationOptionImpl(this, cont);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getIndex(), "Command", filter.getCmd(), "Argument", filter.getArg(), "Execute", this.execOption, "Continue", this.contOption), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public DbgEventFilter getFilter() {
        return this.filter;
    }

    @Override
    public int getEventIndex() {
        return this.filter.getIndex();
    }

    @Override
    public void eventSelected(AbstractDbgEvent<?> event, DbgCause cause) {
        this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
        if (event instanceof DbgThreadCreatedEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_CREATE_THREAD.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgThreadExitedEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_EXIT_THREAD.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgProcessCreatedEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_CREATE_PROCESS.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgProcessExitedEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_EXIT_PROCESS.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgModuleLoadedEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_LOAD_MODULE.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgModuleUnloadedEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_UNLOAD_MODULE.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgInitialBreakpointEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_INITIAL_BREAKPOINT.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgInitialModuleLoadEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_INITIAL_MODULE_LOAD.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgSystemErrorEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_SYSTEM_ERROR.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
        if (event instanceof DbgConsoleOutputEvent && this.getEventIndex() == DebugControl.DebugFilterOrdinals.DEBUG_FILTER_DEBUGGEE_OUTPUT.ordinal()) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
        }
    }

    public Map<String, TargetMethod.ParameterDescription<?>> getConfigurableOptions() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription cmdDesc = TargetMethod.ParameterDescription.create(String.class, (String)"Command", (boolean)false, (Object)"", (String)"Command", (String)"filter command");
        map.put("Command", cmdDesc);
        TargetMethod.ParameterDescription argDesc = TargetMethod.ParameterDescription.create(String.class, (String)"Argument", (boolean)false, (Object)"", (String)"Argument", (String)"filter argument");
        map.put("Argument", argDesc);
        TargetMethod.ParameterDescription execDesc = TargetMethod.ParameterDescription.create(Integer.class, (String)"Execute", (boolean)false, (Object)this.execOption.getOption(), (String)"Execute", (String)"filter execution option");
        map.put("Execute", execDesc);
        TargetMethod.ParameterDescription contDesc = TargetMethod.ParameterDescription.create(Integer.class, (String)"Continue", (boolean)false, (Object)this.contOption.getOption(), (String)"Continue", (String)"filter continuation option");
        map.put("Continue", contDesc);
        return map;
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        DbgManagerImpl manager = this.getManager();
        switch (key) {
            case "Command": {
                if (value instanceof String) {
                    this.changeAttributes(List.of(), Map.of("Command", value), "Modified");
                    String cmd = (String)this.getCachedAttribute("Command");
                    return manager.execute(new DbgSetFilterCommandCommand(manager, this.getEventIndex(), cmd));
                }
                throw new DebuggerIllegalArgumentException("Command should be a string");
            }
            case "Argument": {
                if (value instanceof String) {
                    this.changeAttributes(List.of(), Map.of("Argument", value), "Modified");
                    String cmd = (String)this.getCachedAttribute("Argument");
                    return manager.execute(new DbgSetFilterArgumentCommand(manager, this.getEventIndex(), cmd));
                }
                throw new DebuggerIllegalArgumentException("Argument should be a string");
            }
            case "Execute": {
                if (value instanceof Integer) {
                    return this.execOption.setOption((Integer)value);
                }
                throw new DebuggerIllegalArgumentException("Option should be numeric");
            }
            case "Continue": {
                if (value instanceof Integer) {
                    return this.contOption.setOption((Integer)value);
                }
                throw new DebuggerIllegalArgumentException("Option should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

