/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.datatype.microsoft.GUID;
import java.util.ArrayList;
import java.util.List;

public class OemDefinableString2MsType
extends AbstractMsType {
    public static final int PDB_ID = 4113;
    private GUID guid;
    private List<RecordNumber> recordNumbers = new ArrayList<RecordNumber>();
    private byte[] remainingBytes;

    public OemDefinableString2MsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.guid = reader.parseGUID();
        int count = reader.parseInt();
        for (int i = 0; i < count; ++i) {
            RecordNumber aRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
            this.recordNumbers.add(aRecordNumber);
        }
        this.remainingBytes = reader.parseBytesRemaining();
    }

    @Override
    public int getPdbId() {
        return 4113;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(String.format("OEM Definable String 2\n", new Object[0]));
        builder.append(String.format("  GUID: %s\n", this.guid.toString()));
        builder.append(String.format("  count: %d\n", this.recordNumbers.size()));
        for (int i = 0; i < this.recordNumbers.size(); ++i) {
            builder.append(String.format("    recordNumber[%d]: 0x%08x\n", i, this.recordNumbers.get(i).getNumber()));
        }
        builder.append(String.format("  additional data length: %d\n", this.remainingBytes.length));
    }
}

