/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public interface TraceMemoryOperations {
    public Trace getTrace();

    public TraceMemoryRegion addRegion(String var1, Range<Long> var2, AddressRange var3, Collection<TraceMemoryFlag> var4) throws TraceOverlappedRegionException, DuplicateNameException;

    default public TraceMemoryRegion addRegion(String path, Range<Long> lifespan, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, lifespan, range, Arrays.asList(flags));
    }

    default public TraceMemoryRegion createRegion(String path, long snap, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(snap)), range, flags);
    }

    default public TraceMemoryRegion createRegion(String path, long snap, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(snap)), range, flags);
    }

    public Collection<? extends TraceMemoryRegion> getAllRegions();

    public TraceMemoryRegion getLiveRegionByPath(long var1, String var3);

    public TraceMemoryRegion getRegionContaining(long var1, Address var3);

    public Collection<? extends TraceMemoryRegion> getRegionsIntersecting(Range<Long> var1, AddressRange var2);

    public Collection<? extends TraceMemoryRegion> getRegionsAtSnap(long var1);

    public AddressSetView getRegionsAddressSet(long var1);

    public AddressSetView getRegionsAddressSetWith(long var1, Predicate<TraceMemoryRegion> var3);

    public void setState(long var1, AddressRange var3, TraceMemoryState var4);

    public void setState(long var1, Address var3, TraceMemoryState var4);

    public void setState(long var1, Address var3, Address var4, TraceMemoryState var5);

    public void setState(long var1, AddressSetView var3, TraceMemoryState var4);

    public TraceMemoryState getState(long var1, Address var3);

    public Map.Entry<Long, TraceMemoryState> getViewState(long var1, Address var3);

    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getMostRecentStateEntry(long var1, Address var3);

    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getViewMostRecentStateEntry(long var1, Address var3);

    public AddressSetView getAddressesWithState(long var1, AddressSetView var3, Predicate<TraceMemoryState> var4);

    public AddressSetView getAddressesWithState(long var1, Predicate<TraceMemoryState> var3);

    public AddressSetView getAddressesWithState(Range<Long> var1, Predicate<TraceMemoryState> var2);

    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long var1, AddressRange var3);

    public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(TraceAddressSnapRange var1);

    default public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(long snap, AddressRange range) {
        return this.getMostRecentStates(new ImmutableTraceAddressSnapRange(range.getMinAddress(), range.getMaxAddress(), Long.MIN_VALUE, snap));
    }

    public int putBytes(long var1, Address var3, ByteBuffer var4);

    public int getBytes(long var1, Address var3, ByteBuffer var4);

    public int getViewBytes(long var1, Address var3, ByteBuffer var4);

    public Address findBytes(long var1, AddressRange var3, ByteBuffer var4, ByteBuffer var5, boolean var6, TaskMonitor var7);

    public void removeBytes(long var1, Address var3, int var4);

    public MemBuffer getBufferAt(long var1, Address var3, ByteOrder var4);

    default public MemBuffer getBufferAt(long snap, Address start) {
        return this.getBufferAt(snap, start, this.getTrace().getBaseLanguage().isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    public Long getSnapOfMostRecentChangeToBlock(long var1, Address var3);

    public int getBlockSize();

    public void pack();
}

