/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorState;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.pcode.exec.trace.UnknownStatePcodeExecutionException;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.MemBufferAdapter;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TraceCachedWriteBytesPcodeExecutorState
extends AbstractLongOffsetPcodeExecutorState<byte[], CachedSpace> {
    protected final Map<AddressSpace, CachedSpace> spaces = new HashMap<AddressSpace, CachedSpace>();
    protected final Trace trace;
    protected final long snap;
    protected final TraceThread thread;
    protected final int frame;

    public TraceCachedWriteBytesPcodeExecutorState(Trace trace, long snap, TraceThread thread, int frame) {
        super(trace.getBaseLanguage(), (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)trace.getBaseLanguage()));
        this.trace = trace;
        this.snap = snap;
        this.thread = thread;
        this.frame = frame;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public long getSnap() {
        return this.snap;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public int getFrame() {
        return this.frame;
    }

    public void writeCacheDown(Trace trace, long snap, TraceThread thread, int frame) {
        if (trace.getBaseLanguage() != this.language) {
            throw new IllegalArgumentException("Destination trace must be same language as source");
        }
        for (CachedSpace cached : this.spaces.values()) {
            cached.writeDown(trace, snap, thread, frame);
        }
    }

    protected long offsetToLong(byte[] offset) {
        return Utils.bytesToLong((byte[])offset, (int)offset.length, (boolean)this.language.isBigEndian());
    }

    public byte[] longToOffset(AddressSpace space, long l) {
        return (byte[])this.arithmetic.fromConst(l, space.getPointerSize());
    }

    protected CachedSpace newSpace(AddressSpace space, TraceMemorySpace source, long snap) {
        return new CachedSpace(this.language, space, source, snap);
    }

    protected CachedSpace getForSpace(AddressSpace space, boolean toWrite) {
        return this.spaces.computeIfAbsent(space, s -> {
            TraceMemorySpace tms = s.isUniqueSpace() ? null : TraceSleighUtils.getSpaceForExecution(s, this.trace, this.thread, this.frame, false);
            return this.newSpace((AddressSpace)s, tms, this.snap);
        });
    }

    protected void setInSpace(CachedSpace space, long offset, int size, byte[] val) {
        assert (size == val.length);
        space.write(offset, val, 0, val.length);
    }

    protected byte[] getFromSpace(CachedSpace space, long offset, int size) {
        byte[] read = space.read(offset, size);
        if (read.length != size) {
            Address addr = space.space.getAddress(offset);
            throw new UnknownStatePcodeExecutionException("Incomplete read (" + read.length + " of " + size + " bytes)", this.language, addr.add((long)read.length), size - read.length);
        }
        return read;
    }

    public MemBuffer getConcreteBuffer(Address address) {
        return new StateMemBuffer(address, this.getForSpace(address.getAddressSpace(), false));
    }

    protected static class CachedSpace {
        protected final SemisparseByteArray cache = new SemisparseByteArray();
        protected final RangeSet<UnsignedLong> written = TreeRangeSet.create();
        protected final Language language;
        protected final AddressSpace space;
        protected final TraceMemorySpace source;
        protected final long snap;

        public CachedSpace(Language language, AddressSpace space, TraceMemorySpace source, long snap) {
            this.language = language;
            this.space = space;
            this.source = source;
            this.snap = snap;
        }

        public void write(long offset, byte[] buffer, int srcOffset, int length) {
            this.cache.putData(offset, buffer, srcOffset, length);
            UnsignedLong uLoc = UnsignedLong.fromLongBits((long)offset);
            UnsignedLong uEnd = UnsignedLong.fromLongBits((long)(offset + (long)length));
            this.written.add(Range.closedOpen((Comparable)uLoc, (Comparable)uEnd));
        }

        public static long lower(Range<UnsignedLong> rng) {
            return rng.lowerBoundType() == BoundType.CLOSED ? ((UnsignedLong)rng.lowerEndpoint()).longValue() : ((UnsignedLong)rng.lowerEndpoint()).longValue() + 1L;
        }

        public static long upper(Range<UnsignedLong> rng) {
            return rng.upperBoundType() == BoundType.CLOSED ? ((UnsignedLong)rng.upperEndpoint()).longValue() : ((UnsignedLong)rng.upperEndpoint()).longValue() - 1L;
        }

        protected void readUninitializedFromSource(RangeSet<UnsignedLong> uninitialized) {
            if (!uninitialized.isEmpty()) {
                Range toRead = uninitialized.span();
                assert (toRead.hasUpperBound() && toRead.hasLowerBound());
                long lower = CachedSpace.lower((Range<UnsignedLong>)toRead);
                long upper = CachedSpace.upper((Range<UnsignedLong>)toRead);
                ByteBuffer buf = ByteBuffer.allocate((int)(upper - lower + 1L));
                this.source.getBytes(this.snap, this.space.getAddress(lower), buf);
                for (Range rng : uninitialized.asRanges()) {
                    long l = CachedSpace.lower((Range<UnsignedLong>)rng);
                    long u = CachedSpace.upper((Range<UnsignedLong>)rng);
                    this.cache.putData(l, buf.array(), (int)(l - lower), (int)(u - l + 1L));
                }
            }
        }

        protected byte[] readCached(long offset, int size) {
            byte[] data = new byte[size];
            this.cache.getData(offset, data);
            return data;
        }

        protected AddressRange addrRng(Range<UnsignedLong> rng) {
            Address start = this.space.getAddress(CachedSpace.lower(rng));
            Address end = this.space.getAddress(CachedSpace.upper(rng));
            return new AddressRangeImpl(start, end);
        }

        protected AddressSet addrSet(RangeSet<UnsignedLong> set) {
            AddressSet result = new AddressSet();
            for (Range rng : set.asRanges()) {
                result.add(this.addrRng((Range<UnsignedLong>)rng));
            }
            return result;
        }

        protected Set<Register> getRegs(AddressSet set) {
            TreeSet<Register> regs = new TreeSet<Register>();
            for (AddressRange rng : set) {
                Register r = this.language.getRegister(rng.getMinAddress(), (int)rng.getLength());
                if (r != null) {
                    regs.add(r);
                    continue;
                }
                regs.addAll(Arrays.asList(this.language.getRegisters(rng.getMinAddress())));
            }
            return regs;
        }

        protected void warnState(AddressSet set, String message) {
            Set<Register> regs = this.getRegs(set);
            if (regs.isEmpty()) {
                Msg.warn((Object)this, (Object)(message + ": " + set));
            } else {
                Msg.warn((Object)this, (Object)(message + ": " + set + " (registers " + regs + ")"));
            }
        }

        protected void warnUninit(RangeSet<UnsignedLong> uninit) {
            AddressSet uninitialized = this.addrSet(uninit);
            Set<Register> regs = this.getRegs(uninitialized);
            if (regs.isEmpty()) {
                Msg.warn((Object)this, (Object)("Emulator read from uninitialized state: " + uninit));
            }
            Msg.warn((Object)this, (Object)("Emulator read from uninitialized state: " + uninit + " (includes registers: " + regs + ")"));
        }

        protected void warnUnknown(AddressSet unknown) {
            Set<Register> regs = this.getRegs(unknown);
            Msg.warn((Object)this, (Object)("Emulator state initialized from UNKNOWN: " + unknown + "(includes registers: " + regs + ")"));
        }

        public byte[] read(long offset, int size) {
            RangeSet stillUninit;
            if (this.source != null) {
                this.readUninitializedFromSource((RangeSet<UnsignedLong>)this.cache.getUninitialized(offset, offset + (long)size - 1L));
            }
            if (!(stillUninit = this.cache.getUninitialized(offset, offset + (long)size - 1L)).isEmpty()) {
                this.warnUninit((RangeSet<UnsignedLong>)stillUninit);
            }
            return this.readCached(offset, size);
        }

        protected void writeDown(Trace trace, long snap, TraceThread thread, int frame) {
            if (this.space.isUniqueSpace()) {
                return;
            }
            byte[] data = new byte[4096];
            ByteBuffer buf = ByteBuffer.wrap(data);
            TraceMemorySpace mem = TraceSleighUtils.getSpaceForExecution(this.space, trace, thread, frame, true);
            for (Range range : this.written.asRanges()) {
                int len;
                assert (range.lowerBoundType() == BoundType.CLOSED);
                assert (range.upperBoundType() == BoundType.OPEN);
                long lower = ((UnsignedLong)range.lowerEndpoint()).longValue();
                for (long fullLen = ((UnsignedLong)range.upperEndpoint()).longValue() - lower; fullLen > 0L; fullLen -= (long)len) {
                    len = MathUtilities.unsignedMin((int)data.length, (long)fullLen);
                    this.cache.getData(lower, data, 0, len);
                    buf.position(0);
                    buf.limit(len);
                    mem.putBytes(snap, this.space.getAddress(lower), buf);
                    lower += (long)len;
                }
            }
        }
    }

    protected class StateMemBuffer
    implements MemBufferAdapter {
        protected final Address address;
        protected final CachedSpace source;

        public StateMemBuffer(Address address, CachedSpace source) {
            this.address = address;
            this.source = source;
        }

        public Address getAddress() {
            return this.address;
        }

        public Memory getMemory() {
            return null;
        }

        public boolean isBigEndian() {
            return TraceCachedWriteBytesPcodeExecutorState.this.trace.getBaseLanguage().isBigEndian();
        }

        @Override
        public int getBytes(ByteBuffer buffer, int addressOffset) {
            byte[] data = this.source.read(this.address.getOffset() + (long)addressOffset, buffer.remaining());
            buffer.put(data);
            return data.length;
        }
    }
}

