/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps;

import java.util.LinkedList;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ps.PartitionSystemHandlerFactory;
import org.catacombae.jparted.lib.ps.PartitionSystemType;

public class PartitionSystemDetector {
    public static PartitionSystemType[] detectPartitionSystem(DataLocator inputDataLocator) {
        ReadableRandomAccessStream dlStream = inputDataLocator.createReadOnlyFile();
        PartitionSystemType[] result = PartitionSystemDetector.detectPartitionSystem(dlStream);
        dlStream.close();
        return result;
    }

    public static PartitionSystemType[] detectPartitionSystem(ReadableRandomAccessStream psStream) {
        long len;
        try {
            len = psStream.length();
        }
        catch (RuntimeIOException e) {
            len = -1L;
        }
        return PartitionSystemDetector.detectPartitionSystem(psStream, 0L, len);
    }

    public static PartitionSystemType[] detectPartitionSystem(ReadableRandomAccessStream psStream, long off, long len) {
        LinkedList<PartitionSystemType> result = new LinkedList<PartitionSystemType>();
        for (PartitionSystemType type : PartitionSystemType.values()) {
            PartitionSystemHandlerFactory fact = type.createDefaultHandlerFactory();
            if (fact == null || !fact.getRecognizer().detect(psStream, off, len)) continue;
            result.add(type);
        }
        return result.toArray(new PartitionSystemType[result.size()]);
    }
}

