/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.MergeableBackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.mgr.BackgroundCommandTask;
import ghidra.framework.plugintool.mgr.EmptyBackgroundCommand;
import ghidra.framework.plugintool.mgr.ToolTaskMonitor;
import ghidra.util.Msg;
import ghidra.util.datastruct.PriorityQueue;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;

public class ToolTaskManager
implements Runnable {
    private volatile PluginTool tool;
    private volatile boolean isExecuting;
    private LinkedList<BackgroundCommandTask> tasks = new LinkedList();
    private Map<UndoableDomainObject, PriorityQueue<BackgroundCommand>> queuedCommandsMap = new HashMap<UndoableDomainObject, PriorityQueue<BackgroundCommand>>();
    private Map<UndoableDomainObject, Integer> openForgroundTransactionIDs = new HashMap<UndoableDomainObject, Integer>();
    private long startQueueTime = 0L;
    private long startTaskTime = 0L;
    private Thread taskThread;
    private ThreadGroup taskThreadGroup;
    private ToolTaskMonitor toolTaskMonitor;
    private BackgroundCommandTask currentTask;
    private TaskDialog modalTaskDialog;

    public ToolTaskManager(PluginTool tool) {
        this.tool = tool;
        this.toolTaskMonitor = new ToolTaskMonitor(tool);
        this.toolTaskMonitor.setName("Progress Monitor");
        this.taskThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Background-Task-Group-" + tool.getName());
    }

    public ThreadGroup getTaskThreadGroup() {
        return this.taskThreadGroup;
    }

    public JComponent getMonitorComponent() {
        return this.toolTaskMonitor;
    }

    public synchronized boolean isBusy() {
        return this.isExecuting || this.taskThread != null && this.taskThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Command cmd, DomainObject obj) {
        if (this.tool == null) {
            return false;
        }
        this.tool.clearStatusInfo();
        boolean success = false;
        this.isExecuting = true;
        try {
            if (obj instanceof UndoableDomainObject) {
                UndoableDomainObject undoObj = (UndoableDomainObject)obj;
                success = this.applyCommand(cmd, undoObj);
            } else {
                success = cmd.applyTo(obj);
            }
        }
        finally {
            this.isExecuting = false;
        }
        if (!success) {
            String statusMessage = cmd.getName() + " failed";
            String cmdMessage = cmd.getStatusMsg();
            if (cmdMessage != null) {
                statusMessage = statusMessage + ": " + cmdMessage;
            }
            this.tool.setStatusInfo(statusMessage);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean applyCommand(Command cmd, UndoableDomainObject domainObject) {
        boolean success;
        block9: {
            success = false;
            boolean error = false;
            String cmdName = cmd.getName();
            int id = domainObject.startTransaction(cmdName);
            try {
                success = cmd.applyTo(domainObject);
                this.executeQueueCommands(domainObject, cmdName);
            }
            catch (Throwable t) {
                block8: {
                    error = true;
                    this.clearQueuedCommands(domainObject);
                    if (t instanceof DomainObjectException) {
                        t = t.getCause();
                    }
                    if (t instanceof ConnectException) {
                        boolean bl = false;
                        domainObject.endTransaction(id, !error);
                        return bl;
                    }
                    if (!(t instanceof RollbackException)) break block8;
                    boolean bl = false;
                    domainObject.endTransaction(id, !error);
                    return bl;
                }
                Msg.showError((Object)this, null, (String)"Command Failure", (Object)("An unexpected error occurred running command: " + cmd.getName()), (Throwable)t);
            }
            domainObject.endTransaction(id, !error);
            break block9;
            {
                catch (Throwable throwable) {
                    domainObject.endTransaction(id, !error);
                    throw throwable;
                }
            }
        }
        return success;
    }

    public synchronized void executeCommand(BackgroundCommand cmd, UndoableDomainObject obj) {
        if (this.tool == null) {
            return;
        }
        BackgroundCommandTask task = new BackgroundCommandTask(this, obj, cmd);
        this.tasks.addLast(task);
        if (this.taskThread != null && this.taskThread.isAlive()) {
            return;
        }
        this.taskThread = new Thread(this.taskThreadGroup, this, "Background-Task-" + this.tool.getName());
        this.taskThread.setPriority(2);
        this.taskThread.start();
        try {
            this.wait(1000L);
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)"Interrupted waiting for the Background Command to start a transaction");
        }
    }

    public synchronized void scheduleFollowOnCommand(BackgroundCommand cmd, UndoableDomainObject obj) {
        if (this.isProcessingDomainObject(obj)) {
            PriorityQueue queue = this.queuedCommandsMap.get(obj);
            if (queue == null) {
                queue = new PriorityQueue();
                this.queuedCommandsMap.put(obj, (PriorityQueue<BackgroundCommand>)queue);
            }
            if (!this.mergeMergeableBackgroundCommands(cmd, (PriorityQueue<BackgroundCommand>)queue)) {
                queue.add((Object)cmd, 1);
            }
        } else {
            this.executeCommand(cmd, obj);
        }
    }

    private boolean isProcessingDomainObject(UndoableDomainObject obj) {
        if (this.taskThread == null) {
            return false;
        }
        if (this.hasQueuedTasksForDomainObject(obj)) {
            return true;
        }
        return this.currentTask != null && !this.currentTask.isDoneQueueProcessing();
    }

    private boolean mergeMergeableBackgroundCommands(BackgroundCommand newCommand, PriorityQueue<BackgroundCommand> queue) {
        BackgroundCommand lastCommand = (BackgroundCommand)queue.getLast();
        if (!(lastCommand instanceof MergeableBackgroundCommand) || !(newCommand instanceof MergeableBackgroundCommand)) {
            return false;
        }
        MergeableBackgroundCommand mergeableBackgroundCommand = (MergeableBackgroundCommand)lastCommand;
        MergeableBackgroundCommand newMergeableBackgroundCommand = (MergeableBackgroundCommand)newCommand;
        mergeableBackgroundCommand.mergeCommands(newMergeableBackgroundCommand);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean wait) {
        Thread oldTaskThread = null;
        ToolTaskManager toolTaskManager = this;
        synchronized (toolTaskManager) {
            if (this.isBusy()) {
                this.toolTaskMonitor.cancel();
                oldTaskThread = this.taskThread;
            }
            if (this.currentTask != null) {
                this.clearQueuedCommands(this.currentTask.getDomainObject());
            }
        }
        if (oldTaskThread != null && wait) {
            try {
                oldTaskThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Msg.debug((Object)this, (Object)(new Date() + " Background processing started..."));
            this.startQueueTime = System.currentTimeMillis();
            BackgroundCommandTask task = this.getNextTask();
            while (task != null) {
                Msg.debug((Object)this, (Object)(new Date() + " Exec Task " + task.getTaskTitle()));
                this.startTaskTime = System.currentTimeMillis();
                ToolTaskManager toolTaskManager = this;
                synchronized (toolTaskManager) {
                    this.currentTask = task;
                }
                if (task.isModal()) {
                    this.modalTaskDialog = new TaskDialog((Task)task);
                    this.modalTaskDialog.show(0);
                    task.run((TaskMonitor)this.modalTaskDialog);
                } else {
                    this.toolTaskMonitor.initialize(task);
                    task.run((TaskMonitor)this.toolTaskMonitor);
                }
                task = this.getNextTask();
            }
            double totalTime = (double)(System.currentTimeMillis() - this.startQueueTime) / 1000.0;
            Msg.debug((Object)this, (Object)(new Date() + " Background processing complete (" + totalTime + " secs)"));
        }
        finally {
            ToolTaskManager toolTaskManager = this;
            synchronized (toolTaskManager) {
                this.currentTask = null;
            }
        }
    }

    private synchronized BackgroundCommandTask getNextTask() {
        if (this.tasks.isEmpty()) {
            this.taskThread = null;
            return null;
        }
        return this.tasks.removeFirst();
    }

    private synchronized BackgroundCommand getNextCommand(UndoableDomainObject obj) {
        PriorityQueue<BackgroundCommand> queue = this.queuedCommandsMap.get(obj);
        if (queue == null) {
            return null;
        }
        BackgroundCommand cmd = (BackgroundCommand)queue.removeFirst();
        if (queue.isEmpty()) {
            this.queuedCommandsMap.remove(obj);
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(UndoableDomainObject obj, BackgroundCommandTask task, TaskMonitor monitor) {
        Object cmd;
        double taskTime = (double)(System.currentTimeMillis() - this.startTaskTime) / 1000.0;
        Msg.debug((Object)this, (Object)(new Date() + " " + task.getTaskTitle() + " task finish (" + taskTime + " secs)"));
        obj.flushEvents();
        try {
            while (!monitor.isCancelled()) {
                ToolTaskManager toolTaskManager = this;
                synchronized (toolTaskManager) {
                    cmd = this.getNextCommand(obj);
                    if (cmd == null) {
                        task.setDoneQueueProcessing();
                        break;
                    }
                }
                Msg.debug((Object)this, (Object)(new Date() + "  Queue - " + ((BackgroundCommand)cmd).getName()));
                this.toolTaskMonitor.updateTaskCmd((BackgroundCommand)cmd);
                long localStart = System.currentTimeMillis();
                ((BackgroundCommand)cmd).applyTo(obj, monitor);
                ((BackgroundCommand)cmd).taskCompleted();
                double totalTime = (double)(System.currentTimeMillis() - localStart) / 1000.0;
                Msg.debug((Object)this, (Object)(new Date() + "  (" + totalTime + " secs)"));
                obj.flushEvents();
            }
        }
        finally {
            try {
                if (monitor.isCancelled()) {
                    this.clearQueuedCommands(obj);
                    if (this.tool != null) {
                        this.tool.setStatusInfo(task.getCommand().getName() + " cancelled");
                    }
                }
                cmd = this;
                synchronized (cmd) {
                    Integer openForgroundTransactionID = this.openForgroundTransactionIDs.remove(obj);
                    if (openForgroundTransactionID != null) {
                        obj.endTransaction(openForgroundTransactionID, true);
                    }
                }
            }
            finally {
                if (this.currentTask.isModal()) {
                    this.modalTaskDialog.taskProcessed();
                    this.modalTaskDialog = null;
                } else {
                    this.toolTaskMonitor.taskCompleted(this.currentTask);
                }
            }
        }
        task.getCommand().taskCompleted();
        double totalTime = (double)(System.currentTimeMillis() - this.startTaskTime) / 1000.0;
        Msg.debug((Object)this, (Object)(new Date() + " " + task.getTaskTitle() + " task complete (" + totalTime + " secs)"));
    }

    public synchronized void clearQueuedCommands(UndoableDomainObject obj) {
        PriorityQueue<BackgroundCommand> queue = this.queuedCommandsMap.get(obj);
        if (queue == null) {
            return;
        }
        while (!queue.isEmpty()) {
            BackgroundCommand cmd = (BackgroundCommand)queue.removeFirst();
            cmd.dispose();
        }
        this.queuedCommandsMap.remove(obj);
    }

    public synchronized void clearTasks(UndoableDomainObject obj) {
        Iterator iter = this.tasks.iterator();
        while (iter.hasNext()) {
            BackgroundCommandTask task = (BackgroundCommandTask)iter.next();
            if (task.getDomainObject() != obj) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFailed(UndoableDomainObject obj, BackgroundCommand taskCmd, TaskMonitor monitor) {
        try {
            obj.flushEvents();
            this.clearQueuedCommands(obj);
            if (this.tool != null) {
                if (!monitor.isCancelled()) {
                    monitor.cancel();
                    String msg = taskCmd.getStatusMsg();
                    if (msg == null || msg.length() == 0) {
                        msg = "Unspecified error occurred.";
                    }
                    Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)(taskCmd.getName() + " Failed"), (Object)msg);
                } else {
                    this.tool.setStatusInfo(taskCmd.getName() + " cancelled");
                }
            }
        }
        finally {
            if (this.currentTask.isModal()) {
                this.modalTaskDialog.taskProcessed();
                this.modalTaskDialog = null;
            } else {
                this.toolTaskMonitor.taskCompleted(this.currentTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueueCommands(UndoableDomainObject obj, String title) {
        obj.flushEvents();
        ToolTaskManager toolTaskManager = this;
        synchronized (toolTaskManager) {
            PriorityQueue<BackgroundCommand> queue = this.queuedCommandsMap.get(obj);
            if (queue == null) {
                return;
            }
            if (!this.openForgroundTransactionIDs.containsKey(obj)) {
                this.openForgroundTransactionIDs.put(obj, obj.startTransaction(title));
            }
        }
        EmptyBackgroundCommand cmd = new EmptyBackgroundCommand();
        this.executeCommand(cmd, obj);
    }

    public synchronized void dispose() {
        this.clearTasks();
        ArrayList<UndoableDomainObject> list = new ArrayList<UndoableDomainObject>(this.queuedCommandsMap.keySet());
        for (UndoableDomainObject obj : list) {
            this.clearQueuedCommands(obj);
            Integer txId = this.openForgroundTransactionIDs.get(obj);
            if (txId == null) continue;
            obj.endTransaction(txId, true);
        }
        this.queuedCommandsMap = new HashMap<UndoableDomainObject, PriorityQueue<BackgroundCommand>>();
        this.toolTaskMonitor.dispose();
        if (this.modalTaskDialog != null) {
            this.modalTaskDialog.dispose();
        }
        this.tool = null;
    }

    public synchronized void clearTasks() {
        this.tasks.clear();
    }

    public void cancelCurrentTask() {
        this.toolTaskMonitor.cancel();
    }

    public synchronized boolean hasTasksForDomainObject(DomainObject domainObject) {
        if (!this.isBusy()) {
            return false;
        }
        if (this.currentTask != null && this.currentTask.getDomainObject() == domainObject) {
            return true;
        }
        return this.hasQueuedTasksForDomainObject(domainObject);
    }

    private synchronized boolean hasQueuedTasksForDomainObject(DomainObject domainObject) {
        for (BackgroundCommandTask task : this.tasks) {
            if (task.getDomainObject() != domainObject) continue;
            return true;
        }
        return false;
    }
}

