/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class HandlerMap<T, A, R> {
    private LinkedHashMap<Class<? extends T>, BiFunction<?, ? super A, ? extends R>> map = new LinkedHashMap();

    public <U extends T> BiFunction<? super U, ? super A, ? extends R> put(Class<U> cls, BiFunction<? super U, ? super A, ? extends R> handler) {
        return this.map.put(cls, handler);
    }

    public <U extends T> BiFunction<? super U, ? super A, ? extends R> putVoid(Class<U> cls, BiConsumer<? super U, ? super A> handler) {
        return this.put(cls, (u, a) -> {
            handler.accept((Object)u, (Object)a);
            return null;
        });
    }

    public R handle(T t, A a) {
        BiFunction<?, A, R> function = this.map.get(t.getClass());
        if (function != null) {
            return function.apply(t, a);
        }
        throw new IllegalArgumentException("No handler for " + t);
    }
}

