/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import generic.stl.Pair;
import ghidra.feature.vt.api.db.VTAddressCorrelatorAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AddressCorrelatorDB {
    private VTAddressCorrelatorAdapter adapter;
    private final Program sourceProgram;
    private final Program destinationProgram;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressCorrelatorDB createAddressCorrelator(Program sourceProgram, Program destinationProgram) throws IOException {
        DBHandle dbHandle = new DBHandle();
        AddressCorrelatorDB correlator = new AddressCorrelatorDB(sourceProgram, destinationProgram);
        long ID = dbHandle.startTransaction();
        try {
            correlator.adapter = VTAddressCorrelatorAdapter.createAdapter(dbHandle);
        }
        finally {
            dbHandle.endTransaction(ID, true);
        }
        return correlator;
    }

    public static AddressCorrelatorDB getAddressCorrelator(DBHandle dbHandle, Program sourceProgram, Program destinationProgram, TaskMonitor monitor) throws VersionException {
        AddressCorrelatorDB correlator = new AddressCorrelatorDB(sourceProgram, destinationProgram);
        correlator.adapter = VTAddressCorrelatorAdapter.getAdapter(dbHandle, monitor);
        return correlator;
    }

    private AddressCorrelatorDB(Program sourceProgram, Program destinationProgram) {
        this.sourceProgram = sourceProgram;
        this.destinationProgram = destinationProgram;
    }

    public void addAddressCorrelation(Address sourceEntryPoint, Address sourceAddress, Address destinationAddress) throws IOException {
        long sourceEntryLong = this.getLongFromSourceAddress(sourceEntryPoint);
        long sourceLong = this.getLongFromSourceAddress(sourceAddress);
        long destinationLong = this.getLongFromDestinationAddress(destinationAddress);
        this.adapter.createAddressRecord(sourceEntryLong, sourceLong, destinationLong);
    }

    public List<Pair<Address, Address>> getAddressCorrelations(Address sourceEntryPoint) throws IOException {
        long sourceEntryLong = this.getLongFromSourceAddress(sourceEntryPoint);
        ArrayList<Pair<Address, Address>> addressList = new ArrayList<Pair<Address, Address>>();
        List<DBRecord> addressRecords = this.adapter.getAddressRecords(sourceEntryLong);
        for (DBRecord record : addressRecords) {
            long sourceLong = record.getLongValue(VTAddressCorrelatorAdapter.AddressCorrelationTableDescriptor.SOURCE_ADDRESS_COL.column());
            long destinationLong = record.getLongValue(VTAddressCorrelatorAdapter.AddressCorrelationTableDescriptor.DESTINATION_ADDRESS_COL.column());
            Address sourceAddress = this.getSourceAddressFromLong(sourceLong);
            Address destinationAddress = this.getDestinationAddressFromLong(destinationLong);
            addressList.add((Pair<Address, Address>)new Pair((Object)sourceAddress, (Object)destinationAddress));
        }
        return addressList;
    }

    public void close() {
        this.adapter.close();
    }

    public void save(TaskMonitor monitor) throws CancelledException, IOException {
        this.adapter.save(monitor);
    }

    public void saveAs(File file, TaskMonitor monitor) throws CancelledException, IOException {
        this.adapter.saveAs(file, monitor);
    }

    private long getLongFromSourceAddress(Address address) {
        AddressMap addressMap = this.sourceProgram.getAddressMap();
        return addressMap.getKey(address, false);
    }

    private long getLongFromDestinationAddress(Address address) {
        AddressMap addressMap = this.destinationProgram.getAddressMap();
        return addressMap.getKey(address, false);
    }

    private Address getSourceAddressFromLong(long value) {
        AddressMap addressMap = this.sourceProgram.getAddressMap();
        return addressMap.decodeAddress(value);
    }

    private Address getDestinationAddressFromLong(long value) {
        AddressMap addressMap = this.destinationProgram.getAddressMap();
        return addressMap.decodeAddress(value);
    }
}

