/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Conv;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWARFUtil {
    private static Pattern MANGLED_NESTING_REGEX = Pattern.compile("(.*_Z)?N([0-9]+.*)");
    private static final String OPERATOR_LT_STR = "operator<";
    private static final String OPERATOR_LSHIFT_STR = "operator<<";

    public static String toString(Class<?> clazz, int value) {
        return DWARFUtil.toString(clazz, Conv.intToLong((int)value));
    }

    public static String toString(Class<?> clazz, long value) {
        Field field = DWARFUtil.getStaticFinalFieldWithValue(clazz, value);
        return field != null ? field.getName() : "Unknown DWARF Value: 0x" + Long.toHexString(value);
    }

    public static Field getStaticFinalFieldWithValue(Class<?> clazz, long value) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isFinal(fields[i].getModifiers()) || !Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                long fieldValue = fields[i].getLong(null);
                if (fieldValue != value) continue;
                return fields[i];
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getContainerTypeName(DIEAggregate diea) {
        switch (diea.getTag()) {
            case 19: {
                return "struct";
            }
            case 2: {
                return "class";
            }
            case 4: {
                return "enum";
            }
            case 23: {
                return "union";
            }
            case 11: {
                return "lexical_block";
            }
            case 46: {
                return "subprogram";
            }
            case 21: {
                return "subr";
            }
            case 52: {
                return "var";
            }
        }
        return "unknown";
    }

    public static SymbolType getSymbolTypeFromDIE(DIEAggregate diea) {
        switch (diea.getTag()) {
            case 46: {
                return SymbolType.FUNCTION;
            }
            case 2: 
            case 4: 
            case 19: 
            case 23: 
            case 56: {
                return SymbolType.CLASS;
            }
            case 57: {
                return SymbolType.NAMESPACE;
            }
            default: {
                return null;
            }
            case 5: {
                return SymbolType.PARAMETER;
            }
            case 52: 
        }
        return SymbolType.LOCAL_VAR;
    }

    public static List<String> parseMangledNestings(String s) {
        int len;
        ArrayList<String> results = new ArrayList<String>();
        Matcher m = MANGLED_NESTING_REGEX.matcher(s);
        if (!m.matches()) {
            return results;
        }
        s = m.group(2);
        for (int cp = 0; cp < s.length(); cp += len) {
            int start = cp;
            while (Character.isDigit(s.charAt(cp)) && cp < s.length()) {
                ++cp;
            }
            if (start == cp) break;
            len = Integer.parseInt(s.substring(start, cp));
            if (cp + len > s.length()) continue;
            String name = s.substring(cp, cp + len);
            results.add(name);
        }
        return results;
    }

    public static List<String> findLinkageNameInChildren(DebugInfoEntry die) {
        DWARFProgram prog = die.getCompilationUnit().getProgram();
        for (DebugInfoEntry childDIE : die.getChildren(46)) {
            List<String> nestings;
            DIEAggregate childDIEA = prog.getAggregate(childDIE);
            String linkage = childDIEA.getString(110, null);
            if (linkage == null) {
                linkage = childDIEA.getString(8199, null);
            }
            if (linkage == null || (nestings = DWARFUtil.parseMangledNestings(linkage)).isEmpty()) continue;
            nestings.remove(nestings.size() - 1);
            return nestings;
        }
        return Collections.EMPTY_LIST;
    }

    public static String getTemplateBaseName(String name) {
        int startOfTemplate = name.indexOf(60, name.startsWith(OPERATOR_LSHIFT_STR) ? OPERATOR_LSHIFT_STR.length() : (name.startsWith(OPERATOR_LT_STR) ? OPERATOR_LT_STR.length() : 0));
        return startOfTemplate > 0 && name.indexOf(62) > 0 ? name.substring(0, startOfTemplate).trim() : null;
    }

    public static String getAnonNameForMeFromParentContext(DIEAggregate diea) {
        DebugInfoEntry parent = diea.getHeadFragment().getParent();
        if (parent == null) {
            return null;
        }
        DWARFProgram prog = diea.getProgram();
        int typeDefCount = 0;
        for (DebugInfoEntry childDIE : parent.getChildren()) {
            DIEAggregate childDIEA = prog.getAggregate(childDIE);
            if (diea == childDIEA) {
                return "anon_" + DWARFUtil.getContainerTypeName(childDIEA) + "_" + typeDefCount;
            }
            if (!childDIEA.isNamedType()) continue;
            ++typeDefCount;
        }
        throw new RuntimeException("Could not find child in parent's list of children: child:\n" + diea + ",\nparent:\n" + parent);
    }

    public static String getAnonNameForMeFromParentContext2(DIEAggregate diea) {
        DebugInfoEntry parent = diea.getHeadFragment().getParent();
        if (parent == null) {
            return null;
        }
        DWARFProgram prog = diea.getProgram();
        ArrayList<String> users = new ArrayList<String>();
        for (DebugInfoEntry childDIE : parent.getChildren()) {
            DIEAggregate childDIEA = prog.getAggregate(childDIE);
            String childName = childDIEA.getName();
            DIEAggregate type = childDIEA.getTypeRef();
            if (type != diea || childName == null) continue;
            users.add(childName);
        }
        Collections.sort(users);
        if (users.isEmpty()) {
            return DWARFUtil.getAnonNameForMeFromParentContext(diea);
        }
        StringBuilder sb = new StringBuilder();
        for (String childName : users) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(childName);
        }
        return "anon_" + DWARFUtil.getContainerTypeName(diea) + "_for_" + sb.toString();
    }

    public static String getLexicalBlockName(DIEAggregate diea) {
        return "lexical_block" + DWARFUtil.getLexicalBlockNameWorker(diea.getHeadFragment());
    }

    private static String getLexicalBlockNameWorker(DebugInfoEntry die) {
        if (die.getTag() == 11 || die.getTag() == 29) {
            return DWARFUtil.getLexicalBlockNameWorker(die.getParent()) + "_" + Integer.toString(DWARFUtil.getMyPositionInParent(die));
        }
        return "";
    }

    public static int getMyPositionInParent(DebugInfoEntry die) {
        DebugInfoEntry parent = die.getParent();
        if (parent != null) {
            int position = 0;
            for (DebugInfoEntry childDIE : parent.getChildren(die.getTag())) {
                if (childDIE == die) {
                    return position;
                }
                ++position;
            }
        }
        return -1;
    }

    public static void appendDescription(DataType dt, String description, String sep) {
        if (description == null || description.isEmpty()) {
            return;
        }
        Object prev = dt.getDescription();
        if (prev == null) {
            prev = "";
        }
        if (!((String)prev).isEmpty()) {
            prev = (String)prev + sep;
        }
        dt.setDescription((String)prev + description);
    }

    public static void appendDescription(DataTypeComponent dtc, String description, String sep) {
        if (description == null || description.isEmpty()) {
            return;
        }
        Object prev = dtc.getComment();
        if (prev == null) {
            prev = "";
        }
        if (!((String)prev).isEmpty()) {
            prev = (String)prev + sep;
        }
        dtc.setComment((String)prev + description);
    }

    public static long readOffsetByDWARFformat(BinaryReader reader, int dwarfFormat) throws IOException {
        switch (dwarfFormat) {
            case 32: {
                return reader.readNextUnsignedInt();
            }
            case 64: {
                return reader.readNextLong();
            }
        }
        throw new IOException("Unknown DWARF Format Value: " + dwarfFormat);
    }

    public static long readVarSizedULong(BinaryReader reader, int pointerSize) throws IOException {
        switch (pointerSize) {
            case 1: {
                return reader.readNextUnsignedByte();
            }
            case 2: {
                return reader.readNextUnsignedShort();
            }
            case 4: {
                return reader.readNextUnsignedInt();
            }
            case 8: {
                return reader.readNextLong();
            }
        }
        throw new IOException("Unsupported variable-sized int: " + pointerSize);
    }

    public static int readVarSizedUInt(BinaryReader reader, int size) throws IOException {
        switch (size) {
            case 1: {
                return reader.readNextUnsignedByte();
            }
            case 2: {
                return reader.readNextUnsignedShort();
            }
            case 4: {
                long l = reader.readNextUnsignedInt();
                if (l < 0L || l > Integer.MAX_VALUE) {
                    throw new IOException("Unsigned int value too large: " + l);
                }
                return (int)l;
            }
        }
        throw new IOException("Unsupported variable-sized int: " + size);
    }

    public static Number readAddress(BinaryReader reader, byte pointerSize) throws IOException {
        switch (pointerSize) {
            case 1: {
                return reader.readNextByte();
            }
            case 2: {
                return reader.readNextShort();
            }
            case 4: {
                return reader.readNextInt();
            }
            case 8: {
                return reader.readNextLong();
            }
        }
        throw new IllegalArgumentException("Unknown pointer size: 0x" + Integer.toHexString(pointerSize));
    }

    public static long readAddressAsLong(BinaryReader reader, byte pointerSize) throws IOException {
        switch (pointerSize) {
            case 1: {
                return reader.readNextUnsignedByte();
            }
            case 2: {
                return reader.readNextUnsignedShort();
            }
            case 4: {
                return reader.readNextUnsignedInt();
            }
            case 8: {
                return reader.readNextLong();
            }
        }
        throw new IllegalArgumentException("Unknown pointer size: 0x" + Integer.toHexString(pointerSize));
    }

    public static boolean isThisParam(DIEAggregate paramDIEA) {
        if (paramDIEA.getBool(52, false) || "this".equals(paramDIEA.getName())) {
            return true;
        }
        DWARFAttributeValue dwATObjectPointer = paramDIEA.getParent().getAttribute(100);
        return dwATObjectPointer != null && dwATObjectPointer instanceof DWARFNumericAttribute && paramDIEA.hasOffset(((DWARFNumericAttribute)dwATObjectPointer).getUnsignedValue());
    }

    public static DIEAggregate getReferringTypedef(DIEAggregate diea) {
        if (diea == null) {
            return null;
        }
        List<DIEAggregate> referers = diea.getProgram().getTypeReferers(diea, 22);
        return referers.size() == 1 ? referers.get(0) : null;
    }

    public static LengthResult readLength(BinaryReader reader, Program program) throws IOException, DWARFException {
        int format;
        long length = reader.readNextUnsignedInt();
        if (length == 0xFFFFFFFFL) {
            length = reader.readNextLong();
            format = 64;
        } else {
            if (length >= 0xFFFFFFF0L) {
                throw new DWARFException("Reserved DWARF length value: " + Long.toHexString(length) + ". Unknown extension.");
            }
            if (length == 0L) {
                if (reader.isBigEndian() && program.getDefaultPointerSize() == 8) {
                    length = reader.readNextUnsignedInt();
                    format = 64;
                } else {
                    format = 32;
                }
            } else {
                format = 32;
            }
        }
        return new LengthResult(length, format);
    }

    public static class LengthResult {
        public final long length;
        public final int format;

        private LengthResult(long length, int format) {
            this.length = length;
            this.format = format;
        }
    }
}

