/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.task.TaskMonitor;

public abstract class GccAnalysisClass {
    public static final String NEWLINE = System.getProperty("line.separator");
    protected TaskMonitor monitor;
    protected Program program;
    protected int ptrSize;
    protected Pointer ptrDT;
    protected DWordDataType dwordDT;

    public GccAnalysisClass(TaskMonitor monitor, Program program) {
        this.monitor = monitor;
        this.program = program;
    }

    protected void init(Program program) {
        this.initPointerInfo();
        this.dwordDT = new DWordDataType();
    }

    private void initPointerInfo() {
        this.ptrDT = PointerDataType.getPointer(null, (int)-1);
    }

    protected static void createData(Program program, Address addr, DataType dt) {
        try {
            program.getListing().createData(addr, dt);
        }
        catch (DataTypeConflictException | CodeUnitInsertionException e) {
            CreateDataCmd dataCmd = new CreateDataCmd(addr, dt);
            dataCmd.applyTo((DomainObject)program);
        }
    }

    protected static void createAndCommentData(Program program, Address addr, DataType dt, String comment, int commentType) {
        GccAnalysisClass.createData(program, addr, dt);
        SetCommentCmd.createComment(program, addr, comment, commentType);
    }
}

