/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class FunctionDefinitionLocationDescriptor
extends GenericDataTypeLocationDescriptor {
    private FunctionDefinition functionDefinition;

    FunctionDefinitionLocationDescriptor(ProgramLocation location, Program program, FunctionDefinition functionDefinition) {
        super(location, program, (DataType)functionDefinition);
        this.functionDefinition = functionDefinition;
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        DataType myReturnType = this.functionDefinition.getReturnType();
        ParameterDefinition[] myParameters = this.functionDefinition.getArguments();
        FunctionManager functionManager = this.program.getFunctionManager();
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolIterator symbols = symbolTable.getSymbols(this.functionDefinition.getName());
        while (symbols.hasNext()) {
            FunctionSymbol functionSymbol;
            long symbolID;
            Function function;
            FunctionSignature signature;
            ParameterDefinition[] theirParameters;
            Symbol symbol = symbols.next();
            if (!(symbol instanceof FunctionSymbol) || !this.isSameParamters(myParameters, theirParameters = (signature = (function = functionManager.getFunction(symbolID = (functionSymbol = (FunctionSymbol)symbol).getID())).getSignature(true)).getArguments()) || !myReturnType.isEquivalent(signature.getReturnType())) continue;
            accumulator.add((Object)new LocationReference(symbol.getAddress()));
        }
    }

    private boolean isSameParamters(ParameterDefinition[] myParameters, ParameterDefinition[] theirParameters) {
        if (theirParameters.length != myParameters.length) {
            return false;
        }
        for (int i = 0; i < myParameters.length; ++i) {
            ParameterDefinition myDefinition = myParameters[i];
            ParameterDefinition theirDefinition = theirParameters[i];
            if (myDefinition.isEquivalent(theirDefinition)) continue;
            return false;
        }
        return true;
    }
}

