/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class NextPreviousBookmarkAction
extends MultiStateDockingAction<String> {
    private boolean isForward = true;
    private PluginTool tool;
    private static ImageIcon bookmarkIcon = ResourceManager.loadImage((String)"images/B.gif");
    private static ImageIcon bookmarkAnalysisIcon = ResourceManager.loadImage((String)"images/applications-system.png");
    private static ImageIcon bookmarkErrorIcon = ResourceManager.loadImage((String)"images/edit-delete.png");
    private static ImageIcon bookmarkInfoIcon = ResourceManager.loadImage((String)"images/information.png");
    private static ImageIcon bookmarkNoteIcon = ResourceManager.loadImage((String)"images/notes.gif");
    private static ImageIcon bookmarkWarningIcon = ResourceManager.loadImage((String)"images/warning.png");
    private static ImageIcon bookmarkUnknownIcon = ResourceManager.loadImage((String)"images/unknown.gif");

    public NextPreviousBookmarkAction(PluginTool tool, String owner, String subGroup) {
        super("Next Bookmark", owner);
        this.tool = tool;
        this.setSupportsDefaultToolContext(true);
        ToolBarData toolBarData = new ToolBarData((Icon)bookmarkIcon, "4_Toolbar_Navigation_Group");
        toolBarData.setToolBarSubGroup(subGroup);
        this.setToolBarData(toolBarData);
        this.addToWindowWhen(CodeViewerActionContext.class);
        this.setKeyBindingData(new KeyBindingData(this.getKeyStroke()));
        this.setHelpLocation(new HelpLocation("Navigation", this.getName()));
        this.setDescription("Set bookmark options");
        ActionState allBookmarks = new ActionState("All Types", (Icon)bookmarkIcon, (Object)"All Bookmark Types");
        ActionState analysis = new ActionState("Analysis", (Icon)bookmarkAnalysisIcon, (Object)"Analysis");
        ActionState error = new ActionState("Error", (Icon)bookmarkErrorIcon, (Object)"Error");
        ActionState info = new ActionState("Info", (Icon)bookmarkInfoIcon, (Object)"Info");
        ActionState note = new ActionState("Note", (Icon)bookmarkNoteIcon, (Object)"Note");
        ActionState warning = new ActionState("Warning", (Icon)bookmarkWarningIcon, (Object)"Warning");
        ActionState custom = new ActionState("Custom", (Icon)bookmarkUnknownIcon, (Object)"Custom");
        this.addActionState(allBookmarks);
        this.addActionState(analysis);
        this.addActionState(error);
        this.addActionState(info);
        this.addActionState(note);
        this.addActionState(warning);
        this.addActionState(custom);
        this.setCurrentActionState(allBookmarks);
    }

    public void setMenuBarData(MenuData newMenuData) {
        this.superSetMenuBarData(newMenuData);
    }

    protected void doActionPerformed(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            this.gotoNextPrevious((NavigatableActionContext)context, (String)this.getCurrentUserData());
        }
    }

    public void actionStateChanged(ActionState<String> newActionState, EventTrigger trigger) {
    }

    private Address getNextAddress(Program program, Address address, String bookmarkType) {
        Address start = this.getNextAddressToBeginSearchingForward(program, address);
        Bookmark nextBookmark = this.getNextBookmark(program, start, true, bookmarkType);
        return nextBookmark == null ? null : nextBookmark.getAddress();
    }

    private Address getPreviousAddress(Program program, Address address, String bookmarkType) {
        Address start = this.getNextAddressToBeginSearchingBackward(program, address);
        Bookmark nextBookmark = this.getNextBookmark(program, start, false, bookmarkType);
        return nextBookmark == null ? null : nextBookmark.getAddress();
    }

    private Address getNextAddressToBeginSearchingForward(Program program, Address address) {
        CodeUnit cu = this.getMostPrimitiveCodeUnitContaining(program, address);
        return cu == null ? address : cu.getMaxAddress().next();
    }

    private Address getNextAddressToBeginSearchingBackward(Program program, Address address) {
        CodeUnit cu = this.getMostPrimitiveCodeUnitContaining(program, address);
        return cu == null ? address : cu.getMinAddress().previous();
    }

    private CodeUnit getMostPrimitiveCodeUnitContaining(Program program, Address address) {
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu == null) {
            return null;
        }
        if (cu instanceof Data) {
            Data data = (Data)cu;
            cu = data.getPrimitiveAt((int)address.subtract(data.getAddress()));
        }
        return cu;
    }

    private Bookmark getNextBookmark(Program program, Address address, boolean forward, String bookmarkType) {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        Iterator bookmarkIterator = bookmarkManager.getBookmarksIterator(address, forward);
        while (bookmarkIterator.hasNext()) {
            Bookmark nextBookmark = (Bookmark)bookmarkIterator.next();
            Address nextAddress = nextBookmark.getAddress();
            if (nextAddress.isExternalAddress()) continue;
            if (bookmarkType.equals("All Bookmark Types")) {
                return nextBookmark;
            }
            if (bookmarkType.equals("Custom") && this.isNotBuiltInType(address, nextBookmark, nextAddress)) {
                return nextBookmark;
            }
            if (!nextBookmark.getTypeString().equals(bookmarkType)) continue;
            return nextBookmark;
        }
        if (!bookmarkIterator.hasNext()) {
            return null;
        }
        return (Bookmark)bookmarkIterator.next();
    }

    private boolean isNotBuiltInType(Address address, Bookmark nextBookmark, Address nextAddress) {
        return !nextBookmark.getTypeString().equals("Analysis") && !nextBookmark.getTypeString().equals("Info") && !nextBookmark.getTypeString().equals("Note") && !nextBookmark.getTypeString().equals("Warning") && !nextBookmark.getTypeString().equals("Error") && !nextAddress.equals((Object)address);
    }

    private void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        service.goTo(navigatable, address);
    }

    private void gotoNextPrevious(final NavigatableActionContext context, String bookmarkType) {
        final Address address = this.isForward ? this.getNextAddress(context.getProgram(), context.getAddress(), bookmarkType) : this.getPreviousAddress(context.getProgram(), context.getAddress(), bookmarkType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NextPreviousBookmarkAction.this.gotoAddress(context, address);
            }
        });
    }

    private void gotoAddress(NavigatableActionContext listingActionContext, Address address) {
        if (address == null) {
            this.tool.setStatusInfo("Unable to locate another " + this.getNavigationTypeName() + " past the current range, in the current direction.");
            return;
        }
        this.tool.clearStatusInfo();
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            Navigatable navigatable = listingActionContext.getNavigatable();
            this.gotoAddress(service, navigatable, address);
        }
    }

    public void setDirection(boolean isForward) {
        this.isForward = isForward;
        this.setDescription(this.getToolTipText());
    }

    public String getToolTipText() {
        String description = "Go To " + (this.isForward ? "Next" : "Previous");
        description = description + " Bookmark: " + this.getCurrentState().getName();
        return description;
    }

    private String getNavigationTypeName() {
        return "Bookmark";
    }

    private KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(66, 640);
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof ListingActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof ListingActionContext;
    }
}

