/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.app.cmd.label.ExternalEntryCmd;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;

public class DeleteLabelCmd
implements Command {
    private Address addr;
    private String name;
    private Namespace scope;
    private String errorMsg;
    private ExternalEntryCmd externalEntryCmd;

    public DeleteLabelCmd(Address addr, String name, Namespace scope) {
        this.addr = addr;
        this.name = name;
        this.scope = scope;
    }

    public DeleteLabelCmd(Address addr, String name) {
        this(addr, name, null);
    }

    public boolean applyTo(DomainObject obj) {
        boolean success;
        SymbolTable st = ((Program)obj).getSymbolTable();
        Symbol s = st.getSymbol(this.name, this.addr, this.scope);
        if (s == null) {
            this.errorMsg = "Symbol " + this.name + " not found!";
            return false;
        }
        if (s.isDynamic()) {
            this.errorMsg = "Deleting the dynamic symbol \"" + this.name + "\" @ " + this.addr + " is not allowed.";
            return false;
        }
        if (s.isExternalEntryPoint() && s.isPrimary() && st.getSymbols(s.getAddress()).length == 1) {
            this.externalEntryCmd = new ExternalEntryCmd(this.addr, false);
            this.externalEntryCmd.applyTo(obj);
        }
        if (!(success = st.removeSymbolSpecial(s))) {
            this.errorMsg = "Couldn't delete the symbol \"" + this.name + "\" @ " + this.addr + ".";
        }
        return success;
    }

    public String getName() {
        return "Delete Label";
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }
}

