/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostType1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostTypeSignature;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeSignatureInternal;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostTypeSignature;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DebugHostTypeSignatureImpl
implements DebugHostTypeSignatureInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDebugHostTypeSignature jnaData;
    private DebugHostSymbolEnumeratorInternal wildcardMatches;

    public DebugHostTypeSignatureImpl(IDebugHostTypeSignature jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public int getHashCode() {
        WinDef.ULONGByReference pulHashCode = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetHashCode(pulHashCode));
        return pulHashCode.getValue().intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMatch(DebugHostType1 type) {
        Pointer pType = type.getPointer();
        WinDef.BOOLByReference pIsMatch = new WinDef.BOOLByReference();
        PointerByReference ppWildcardMatches = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.IsMatch(pType, pIsMatch, ppWildcardMatches));
        WrapIModelObject wrap1 = new WrapIModelObject(ppWildcardMatches.getValue());
        try {
            this.wildcardMatches = DebugHostSymbolEnumeratorInternal.tryPreferredInterfaces(wrap1::QueryInterface);
        }
        finally {
            wrap1.Release();
        }
        return pIsMatch.getValue().booleanValue();
    }

    @Override
    public int compareAgainst(DebugHostTypeSignature typeSignature) {
        Pointer pTypeSignature = typeSignature.getPointer();
        WinDef.ULONGByReference pResult = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CompareAgainst(pTypeSignature, pResult));
        return pResult.getValue().intValue();
    }

    public DebugHostSymbolEnumeratorInternal getWildcardMatches() {
        return this.wildcardMatches;
    }
}

