/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbState;
import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.evt.GdbCommandErrorEvent;
import agent.gdb.manager.evt.GdbCommandRunningEvent;
import agent.gdb.manager.evt.GdbConsoleOutputEvent;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.parsing.GdbParsingUtils;
import ghidra.util.Msg;

public abstract class AbstractGdbCommand<T>
implements GdbCommand<T> {
    protected final GdbManagerImpl manager;

    protected AbstractGdbCommand(GdbManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public boolean validInState(GdbState state) {
        return true;
    }

    @Override
    public void preCheck(GdbPendingCommand<? super T> pending) {
    }

    public String toString() {
        return "<GDB/" + this.getInterpreter() + " " + this.encode() + ">";
    }

    @Override
    public GdbManagerImpl.Interpreter getInterpreter() {
        return GdbManagerImpl.Interpreter.MI2;
    }

    protected GdbEvent<?> checkErrorViaCli(GdbEvent<?> evt) {
        GdbConsoleOutputEvent outEvt;
        String out;
        if (evt instanceof GdbConsoleOutputEvent && (out = (outEvt = (GdbConsoleOutputEvent)evt).getOutput()).startsWith("^error")) {
            try {
                return GdbCommandErrorEvent.fromMi2(out.split(",", 2)[1].trim());
            }
            catch (GdbParsingUtils.GdbParseError e) {
                Msg.error((Object)this, (Object)"Could not parse error result", (Throwable)e);
            }
        }
        return evt;
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (evt instanceof GdbCommandRunningEvent) {
            return false;
        }
        if (evt instanceof AbstractGdbCompletedCommandEvent) {
            pending.claim(evt);
            return true;
        }
        return false;
    }

    @Override
    public Integer impliesCurrentThreadId() {
        return null;
    }

    @Override
    public Integer impliesCurrentFrameId() {
        return null;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return true;
    }
}

