/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import org.snpeff.interval.Exon;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChangeStructural;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public class CodonChangeDel
extends CodonChangeStructural {
    public CodonChangeDel(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.returnNow = false;
        this.requireNetCdsChange = true;
    }

    @Override
    protected boolean codonChange(Exon exon) {
        if (this.netCdsChange.isEmpty()) {
            return false;
        }
        EffectType effType = null;
        if (this.variant.includes(exon)) {
            this.codonsRef = "";
            this.codonsAlt = "";
            this.codonStartIndex = -1;
            this.codonStartNum = -1;
            effType = EffectType.EXON_DELETED;
        } else if (this.netCdsChange.length() % 3 != 0) {
            this.codonsRef = this.codonsRef();
            this.codonsAlt = "";
            effType = EffectType.FRAME_SHIFT;
        } else if (this.codonStartIndex == 0) {
            this.codonsRef = this.codonsRef();
            this.codonsAlt = "";
            effType = EffectType.CODON_DELETION;
        } else {
            this.codonsRef = this.codonsRef();
            this.codonsAlt = this.codonsAlt();
            effType = this.codonsAlt.isEmpty() || this.codonsRef.startsWith(this.codonsAlt) ? EffectType.CODON_DELETION : EffectType.CODON_CHANGE_PLUS_CODON_DELETION;
        }
        this.effect(exon, effType, false);
        return true;
    }

    @Override
    protected String codonsAlt() {
        if (this.netCdsChange.isEmpty()) {
            return "";
        }
        int after = this.netCdsChange.length() + this.codonStartIndex;
        String prefix = this.codonsRef.length() >= this.codonStartIndex ? this.codonsRef.substring(0, this.codonStartIndex) : this.codonsRef;
        String suffix = this.codonsRef.length() > after ? this.codonsRef.substring(after) : "";
        String codonsAlt = prefix + suffix;
        return codonsAlt;
    }

    @Override
    protected String codonsRef() {
        if (this.netCdsChange.isEmpty()) {
            return "";
        }
        int min2 = this.variant.getStart();
        int max2 = this.variant.getEnd();
        int cdsBaseMin = this.cdsBaseNumber(min2);
        int cdsBaseMax = this.cdsBaseNumber(max2);
        if (this.transcript.isStrandMinus()) {
            int swap = cdsBaseMin;
            cdsBaseMin = cdsBaseMax;
            cdsBaseMax = swap;
        }
        if (cdsBaseMax < cdsBaseMin) {
            throw new RuntimeException("This should never happen!\n\tcdsBaseMin: " + cdsBaseMin + "\n\tcdsBaseMax: " + cdsBaseMax + "\n\tmin: " + min2 + "\n\tmax: " + max2 + "\n\tSeqChange: " + this.variant + "\n\ttranscript: " + this.transcript + "\n\tCDS.len: " + this.transcript.cds().length());
        }
        int maxCodon = cdsBaseMax / 3;
        int minCodon = cdsBaseMin / 3;
        int oldCodonCdsStart = 3 * minCodon;
        int oldCodonCdsEnd = 3 * (maxCodon + 1) - 1;
        String codons = "";
        codons = oldCodonCdsEnd >= this.transcript.cds().length() ? this.transcript.cds().substring(oldCodonCdsStart) : this.transcript.cds().substring(oldCodonCdsStart, oldCodonCdsEnd + 1);
        return codons;
    }

    @Override
    protected void effectTranscript() {
        this.effectNoCodon(this.transcript, EffectType.TRANSCRIPT_DELETED);
    }

    void exonLoss() {
        for (Exon ex : this.transcript) {
            if (!this.variant.includes(ex)) continue;
            this.effectNoCodon(ex, EffectType.EXON_DELETED);
        }
    }

    @Override
    protected void exons() {
        if (this.exonFull == 0 && this.exonPartial == 1) {
            this.codonChangeSuper();
            return;
        }
        if (this.exonFull > 0) {
            this.exonLoss();
            if (this.exonPartial == 0) {
                return;
            }
        }
        this.codonsRefAlt();
        EffectType effType = null;
        int lenDiff = this.cdsAlt.length() - this.cdsRef.length();
        effType = lenDiff % 3 != 0 ? EffectType.FRAME_SHIFT : (this.codonStartIndex == 0 ? EffectType.CODON_DELETION : (this.codonsAlt.isEmpty() || this.codonsRef.startsWith(this.codonsAlt) ? EffectType.CODON_DELETION : EffectType.CODON_CHANGE_PLUS_CODON_DELETION));
        for (Exon ex : this.transcript) {
            if (!this.variant.includes(ex) && !this.variant.intersects(ex)) continue;
            this.exon = ex;
            break;
        }
        this.effect(this.exon, effType, false);
    }

    @Override
    protected void exonsCoding() {
    }

    @Override
    protected void exonsNoncoding() {
        if (this.exonFull > 0) {
            this.effectNoCodon(this.transcript, EffectType.EXON_DELETED, VariantEffect.EffectImpact.MODIFIER);
        }
        if (this.exonPartial > 0) {
            this.effectNoCodon(this.transcript, EffectType.EXON_DELETED_PARTIAL, VariantEffect.EffectImpact.MODIFIER);
        }
    }

    @Override
    protected void intron() {
        this.effectNoCodon(this.transcript, EffectType.INTRON);
    }
}

