/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import org.snpeff.fileIterator.RegulationFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Regulation;

public class RegulationGffFileIterator
extends RegulationFileIterator {
    public static final int GFF_OFFSET = 1;

    public RegulationGffFileIterator(String fileName) {
        super(fileName, 1);
    }

    public RegulationGffFileIterator(String fileName, Genome genome) {
        super(fileName, genome, 1);
    }

    @Override
    protected Regulation readNext() {
        try {
            while (this.ready()) {
                String[] infos;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int start = this.parsePosition(fields[3]);
                int end = this.parsePosition(fields[4]);
                String strandStr = fields[6];
                boolean strandMinus = strandStr.equals("-");
                String info = fields[8];
                String name = "";
                String type = "";
                for (String nv : infos = info.split(";")) {
                    String[] nameValue = nv.split("=");
                    if (nameValue.length <= 0) continue;
                    String attr = nameValue[0].trim();
                    String val = nameValue[1].trim();
                    if (attr.equals("Name") || attr.equals("feature_type")) {
                        name = val;
                        continue;
                    }
                    if (attr.equals("Cell_type") || attr.equals("description")) {
                        type = val.replaceAll(" - ", "-");
                        continue;
                    }
                    if (!attr.equals("Alias") || !type.isEmpty()) continue;
                    type = val.split("_")[0];
                }
                String id = type + "_" + name + "_" + this.lineNum;
                Regulation reg = new Regulation(chromo, start, end, strandMinus, id, name, type);
                return reg;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

