/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.structure.quaternary.BioAssemblyTools;
import org.biojava.bio.structure.quaternary.OrderedPair;

public class OperatorResolver {
    private List<String> unaryOperators = Collections.emptyList();
    private List<OrderedPair<String>> binaryOperators = Collections.emptyList();

    public void parseOperatorExpressionString(String operatorExpression) throws IllegalArgumentException {
        String expression = operatorExpression.trim();
        if (BioAssemblyTools.isUnaryExpression(expression = expression.replaceAll("'", ""))) {
            this.unaryOperators = BioAssemblyTools.parseUnaryOperatorExpression(expression);
        } else {
            this.binaryOperators = BioAssemblyTools.parseBinaryOperatorExpression(expression);
        }
    }

    public void setUnaryOperators(List<String> unaryOperators) {
        this.unaryOperators = unaryOperators;
    }

    public void setBinaryOperators(List<OrderedPair<String>> binaryOperators) {
        this.binaryOperators = binaryOperators;
    }

    public List<String> getUnaryOperators() {
        return this.unaryOperators;
    }

    public List<OrderedPair<String>> getBinaryOperators() {
        return this.binaryOperators;
    }
}

