/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Formatter;
import org.apfloat.Apcomplex;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.Aprational;
import org.apfloat.FormattingHelper;
import org.apfloat.RadixConversionHelper;
import org.apfloat.spi.ApfloatImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apfloat
extends Apcomplex
implements Comparable<Apfloat> {
    private static final long serialVersionUID = -36707433458144439L;
    private ApfloatImpl impl;

    protected Apfloat() {
    }

    protected Apfloat(ApfloatImpl impl) {
        assert (impl.precision() > 0L);
        this.impl = impl;
    }

    public Apfloat(String value2) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, false));
    }

    public Apfloat(String value2, long precision) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision, false));
    }

    public Apfloat(String value2, long precision, int radix) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision, radix, false));
    }

    public Apfloat(long value2) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2));
    }

    public Apfloat(long value2, long precision) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision));
    }

    public Apfloat(long value2, long precision, int radix) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision, radix));
    }

    public Apfloat(float value2) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2));
    }

    public Apfloat(float value2, long precision) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision));
    }

    public Apfloat(float value2, long precision, int radix) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision, radix));
    }

    public Apfloat(double value2) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2));
    }

    public Apfloat(double value2, long precision) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision));
    }

    public Apfloat(double value2, long precision, int radix) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision, radix));
    }

    public Apfloat(PushbackReader in) throws IOException, NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(in, false));
    }

    public Apfloat(PushbackReader in, long precision) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(in, precision, false));
    }

    public Apfloat(PushbackReader in, long precision, int radix) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(in, precision, radix, false));
    }

    public Apfloat(BigInteger value2) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2));
    }

    public Apfloat(BigInteger value2, long precision) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision));
    }

    public Apfloat(BigInteger value2, long precision, int radix) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision, radix));
    }

    public Apfloat(BigDecimal value2) throws ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2));
    }

    public Apfloat(BigDecimal value2, long precision) throws IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(value2, precision));
    }

    @Override
    public int radix() {
        return this.impl.radix();
    }

    @Override
    public Apfloat real() {
        return this;
    }

    @Override
    public Apfloat imag() {
        return ZERO;
    }

    @Override
    public long precision() throws ApfloatRuntimeException {
        return this.impl.precision();
    }

    @Override
    public Apfloat precision(long precision) throws IllegalArgumentException, ApfloatRuntimeException {
        ApfloatHelper.checkPrecision(precision);
        return new Apfloat(this.getImpl(precision));
    }

    @Override
    public long scale() throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return -9223372036854775807L;
        }
        return this.impl.scale();
    }

    @Override
    public long size() throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return 0L;
        }
        return this.impl.size();
    }

    public int signum() {
        return this.impl.signum();
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.impl.isShort();
    }

    @Override
    public Apfloat negate() throws ApfloatRuntimeException {
        return new Apfloat(this.impl.negate());
    }

    public Apfloat add(Apfloat x2) throws ApfloatRuntimeException {
        if (x2.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return x2;
        }
        return this.addOrSubtract(x2, false);
    }

    public Apfloat subtract(Apfloat x2) throws ApfloatRuntimeException {
        if (x2.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            ApfloatImpl impl = x2.getImpl();
            impl = impl.negate();
            return new Apfloat(impl);
        }
        return this.addOrSubtract(x2, true);
    }

    private Apfloat addOrSubtract(Apfloat x2, boolean subtract) throws ApfloatRuntimeException {
        ApfloatImpl impl;
        long[] precisions = ApfloatHelper.getMatchingPrecisions(this, x2);
        if (precisions[0] == 0L) {
            impl = x2.getImpl(precisions[1]);
            if (subtract) {
                impl = impl.negate();
            }
        } else if (precisions[1] == 0L) {
            impl = this.getImpl(precisions[0]);
        } else {
            impl = this.getImpl(precisions[0]);
            ApfloatImpl xImpl = x2.getImpl(precisions[1]);
            impl = impl.addOrSubtract(xImpl, subtract);
        }
        return new Apfloat(impl);
    }

    public Apfloat multiply(Apfloat x2) throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return this;
        }
        if (x2.signum() == 0) {
            return x2;
        }
        if (this.equals(ONE)) {
            return x2.precision(Math.min(this.precision(), x2.precision()));
        }
        if (x2.equals(ONE)) {
            return this.precision(Math.min(this.precision(), x2.precision()));
        }
        long targetPrecision = Math.min(this.precision(), x2.precision());
        ApfloatImpl thisImpl = this.getImpl(targetPrecision);
        ApfloatImpl xImpl = x2.getImpl(targetPrecision);
        ApfloatImpl impl = thisImpl.multiply(xImpl);
        return new Apfloat(impl);
    }

    public Apfloat divide(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        if (x2.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.signum() == 0) {
            return this;
        }
        if (x2.equals(ONE)) {
            return this.precision(Math.min(this.precision(), x2.precision()));
        }
        long targetPrecision = Math.min(this.precision(), x2.precision());
        if (x2.isShort()) {
            ApfloatImpl thisImpl = this.getImpl(targetPrecision);
            ApfloatImpl xImpl = x2.getImpl(targetPrecision);
            ApfloatImpl impl = thisImpl.divideShort(xImpl);
            return new Apfloat(impl);
        }
        Apfloat inverse = ApfloatMath.inverseRoot(x2, 1L, targetPrecision);
        return this.multiply(inverse);
    }

    public Apfloat mod(Apfloat x2) throws ApfloatRuntimeException {
        return ApfloatMath.fmod(this, x2);
    }

    public Apint floor() throws ApfloatRuntimeException {
        if (this.signum() >= 0) {
            return new Apint(new Apfloat(this.impl.absFloor()));
        }
        return new Apint(new Apfloat(this.impl.absCeil()));
    }

    public Apint ceil() throws ApfloatRuntimeException {
        if (this.signum() >= 0) {
            return new Apint(new Apfloat(this.impl.absCeil()));
        }
        return new Apint(new Apfloat(this.impl.absFloor()));
    }

    public Apint truncate() throws ApfloatRuntimeException {
        return new Apint(new Apfloat(this.impl.absFloor()));
    }

    @Override
    public double doubleValue() {
        int targetPrecision = ApfloatHelper.getDoublePrecision(this.radix());
        ApfloatImpl impl = this.getImpl(targetPrecision);
        return impl.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public byte byteValue() {
        long longValue = this.longValue();
        return (byte)Math.min(Math.max(longValue, -128L), 127L);
    }

    @Override
    public short shortValue() {
        long longValue = this.longValue();
        return (short)Math.min(Math.max(longValue, -32768L), 32767L);
    }

    @Override
    public int intValue() {
        long longValue = this.longValue();
        return (int)Math.min(Math.max(longValue, Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    @Override
    public long longValue() {
        int targetPrecision = ApfloatHelper.getLongPrecision(this.radix());
        ApfloatImpl impl = this.getImpl(targetPrecision);
        return impl.longValue();
    }

    public long equalDigits(Apfloat x2) throws ApfloatRuntimeException {
        long targetPrecision = Math.min(this.precision(), x2.precision());
        ApfloatImpl thisImpl = this.getImpl(targetPrecision);
        ApfloatImpl xImpl = x2.getImpl(targetPrecision);
        return thisImpl.equalDigits(xImpl);
    }

    @Override
    public Apfloat toRadix(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return RadixConversionHelper.toRadix(this, radix);
    }

    @Override
    public int compareTo(Apfloat x2) {
        if (x2 instanceof Aprational) {
            return -x2.compareTo(this);
        }
        return this.getImpl().compareTo(x2.getImpl());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Aprational) {
            return obj.equals(this);
        }
        if (obj instanceof Apfloat) {
            Apfloat x2 = (Apfloat)obj;
            return this.getImpl().equals(x2.getImpl());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public String toString(boolean pretty) throws ApfloatRuntimeException {
        return this.impl.toString(pretty);
    }

    @Override
    public void writeTo(Writer out, boolean pretty) throws IOException, ApfloatRuntimeException {
        this.impl.writeTo(out, pretty);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        Apfloat x2 = precision == -1 ? this : ApfloatHelper.limitPrecision(this, (long)precision);
        try {
            Writer out = FormattingHelper.wrapAppendableWriter(formatter.out());
            out = FormattingHelper.wrapLocalizeWriter(out, formatter, this.radix(), (flags & 2) == 2);
            if (width == -1) {
                x2.writeTo(out, (flags & 4) == 4);
            } else {
                out = FormattingHelper.wrapPadWriter(out, (flags & 1) == 1);
                x2.writeTo(out, (flags & 4) == 4);
                FormattingHelper.finishPad(out, width);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected ApfloatImpl getImpl(long precision) throws ApfloatRuntimeException {
        if (precision == this.precision()) {
            return this.impl;
        }
        return this.impl.precision(precision);
    }

    private ApfloatImpl getImpl() throws ApfloatRuntimeException {
        long precision = this.precision();
        return this.getImpl(precision);
    }
}

