/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.cache.TemplateCache;
import freemarker.core.CustomAttribute;
import freemarker.core.Environment;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jaxen.BaseXPath;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DocumentNavigator;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JaxenXPathSupport
implements XPathSupport {
    private static final CustomAttribute cache = new CustomAttribute(1){

        protected Object create() {
            return new HashMap();
        }
    };
    private static final ArrayList EMPTY_ARRAYLIST = new ArrayList();
    private static final NamespaceContext customNamespaceContext = new NamespaceContext(){

        public String translateNamespacePrefixToUri(String prefix) {
            if (prefix.equals("D")) {
                return Environment.getCurrentEnvironment().getDefaultNS();
            }
            return Environment.getCurrentEnvironment().getNamespaceForPrefix(prefix);
        }
    };
    private static final VariableContext fmVariableContext = new VariableContext(){

        public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
            try {
                TemplateModel model = Environment.getCurrentEnvironment().getVariable(localName);
                if (model == null) {
                    throw new UnresolvableException("Variable " + localName + " not found.");
                }
                if (model instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)model).getAsString();
                }
                if (model instanceof TemplateNumberModel) {
                    return ((TemplateNumberModel)model).getAsNumber();
                }
                if (model instanceof TemplateDateModel) {
                    return ((TemplateDateModel)model).getAsDate();
                }
                if (model instanceof TemplateBooleanModel) {
                    return ((TemplateBooleanModel)model).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (TemplateModelException e) {
                throw new UndeclaredThrowableException(e);
            }
            throw new UnresolvableException("Variable " + localName + " is not a string, number, date, or boolean");
        }
    };
    private static final FunctionContext fmFunctionContext = new XPathFunctionContext(){

        public Function getFunction(String namespaceURI, String prefix, String localName) throws UnresolvableException {
            try {
                return super.getFunction(namespaceURI, prefix, localName);
            }
            catch (UnresolvableException e) {
                return super.getFunction(null, null, localName);
            }
        }
    };
    private static final CustomAttribute cachedTree = new CustomAttribute(1);
    private static final Navigator fmDomNavigator = new DocumentNavigator(){

        public Object getDocument(String uri) throws FunctionCallException {
            try {
                Template raw = JaxenXPathSupport.getTemplate(uri);
                Document doc = (Document)cachedTree.get(raw);
                if (doc == null) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    FmEntityResolver er = new FmEntityResolver();
                    builder.setEntityResolver(er);
                    doc = builder.parse(JaxenXPathSupport.createInputSource(null, raw));
                    if (er.getCallCount() == 0) {
                        cachedTree.set(doc, raw);
                    }
                }
                return doc;
            }
            catch (Exception e) {
                throw new FunctionCallException("Failed to parse document for URI: " + uri, e);
            }
        }
    };

    JaxenXPathSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModel executeQuery(Object context, String xpathQuery) throws TemplateModelException {
        try {
            BaseXPath xpath;
            Map xpathCache;
            Map map2 = xpathCache = (Map)cache.get();
            synchronized (map2) {
                xpath = (BaseXPath)xpathCache.get(xpathQuery);
                if (xpath == null) {
                    xpath = new BaseXPath(xpathQuery, fmDomNavigator);
                    xpath.setNamespaceContext(customNamespaceContext);
                    xpath.setFunctionContext(fmFunctionContext);
                    xpath.setVariableContext(fmVariableContext);
                    xpathCache.put(xpathQuery, xpath);
                }
            }
            List result2 = xpath.selectNodes(context != null ? context : EMPTY_ARRAYLIST);
            if (result2.size() == 1) {
                return ObjectWrapper.DEFAULT_WRAPPER.wrap(result2.get(0));
            }
            NodeListModel nlm = new NodeListModel(result2, null);
            nlm.xpathSupport = this;
            return nlm;
        }
        catch (UndeclaredThrowableException e) {
            Throwable t2 = e.getUndeclaredThrowable();
            if (t2 instanceof TemplateModelException) {
                throw (TemplateModelException)t2;
            }
            throw e;
        }
        catch (JaxenException je) {
            throw new TemplateModelException((Exception)((Object)je));
        }
    }

    static Template getTemplate(String systemId) throws IOException {
        String templatePath;
        int lastSlash;
        Environment env = Environment.getCurrentEnvironment();
        String encoding = env.getTemplate().getEncoding();
        if (encoding == null) {
            encoding = env.getConfiguration().getEncoding(env.getLocale());
        }
        templatePath = (lastSlash = (templatePath = env.getTemplate().getName()).lastIndexOf(47)) == -1 ? "" : templatePath.substring(0, lastSlash + 1);
        systemId = TemplateCache.getFullTemplatePath(env, templatePath, systemId);
        Template raw = env.getConfiguration().getTemplate(systemId, env.getLocale(), encoding, false);
        return raw;
    }

    private static InputSource createInputSource(String publicId, Template raw) throws IOException, SAXException {
        StringWriter sw = new StringWriter();
        try {
            raw.process(Collections12.EMPTY_MAP, sw);
        }
        catch (TemplateException e) {
            throw new SAXException(e);
        }
        InputSource is = new InputSource();
        is.setPublicId(publicId);
        is.setSystemId(raw.getName());
        is.setCharacterStream(new StringReader(sw.toString()));
        return is;
    }

    private static class FmEntityResolver
    implements EntityResolver {
        private int callCount = 0;

        private FmEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            ++this.callCount;
            return JaxenXPathSupport.createInputSource(publicId, JaxenXPathSupport.getTemplate(systemId));
        }

        int getCallCount() {
            return this.callCount;
        }
    }
}

