/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;

    BlockAssignment(TemplateElement nestedBlock, String varName, int scope, Expression namespaceExp) {
        this.nestedBlock = nestedBlock;
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.scope = scope;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock, new CaptureOutput(env), null);
        } else {
            SimpleScalar value2 = new SimpleScalar("");
            if (this.namespaceExp != null) {
                Environment.Namespace ns = (Environment.Namespace)this.namespaceExp.getAsTemplateModel(env);
                ns.put(this.varName, value2);
            } else if (this.scope == 1) {
                env.setVariable(this.varName, value2);
            } else if (this.scope == 3) {
                env.setGlobalVariable(this.varName, value2);
            } else if (this.scope == 2) {
                env.setLocalVariable(this.varName, value2);
            }
        }
    }

    public String getCanonicalForm() {
        String key;
        switch (this.scope) {
            case 2: {
                key = "local";
                break;
            }
            case 3: {
                key = "global";
                break;
            }
            default: {
                key = "assign";
            }
        }
        String block = this.nestedBlock == null ? "" : this.nestedBlock.getCanonicalForm();
        return "<#" + key + " " + this.varName + (this.namespaceExp != null ? " in " + this.namespaceExp.getCanonicalForm() : "") + ">" + block + "</#" + key + ">";
    }

    public String getDescription() {
        return "block assignment to variable: " + this.varName;
    }

    boolean isIgnorable() {
        return false;
    }

    private class CaptureOutput
    implements TemplateTransformModel {
        private final Environment env;
        private final Environment.Namespace fnsModel;

        CaptureOutput(Environment env) throws TemplateException {
            this.env = env;
            TemplateModel nsModel = null;
            if (BlockAssignment.this.namespaceExp != null && !((nsModel = BlockAssignment.this.namespaceExp.getAsTemplateModel(env)) instanceof Environment.Namespace)) {
                throw new TemplateException("namespace parameter does not specify a namespace. It is a " + nsModel.getClass().getName(), env);
            }
            this.fnsModel = (Environment.Namespace)nsModel;
        }

        public Writer getWriter(Writer out, Map args) {
            return new StringWriter(){

                public void close() {
                    SimpleScalar result2 = new SimpleScalar(this.toString());
                    switch (BlockAssignment.this.scope) {
                        case 1: {
                            if (CaptureOutput.this.fnsModel != null) {
                                CaptureOutput.this.fnsModel.put(BlockAssignment.this.varName, result2);
                                break;
                            }
                            CaptureOutput.this.env.setVariable(BlockAssignment.this.varName, result2);
                            break;
                        }
                        case 2: {
                            CaptureOutput.this.env.setLocalVariable(BlockAssignment.this.varName, result2);
                            break;
                        }
                        case 3: {
                            CaptureOutput.this.env.setGlobalVariable(BlockAssignment.this.varName, result2);
                        }
                    }
                }
            };
        }
    }
}

