/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.misc;
import DistLib.uniform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class wilcox {
    private static Log log;
    public static final int WILCOX_MMAX = 50;
    public static final int WILCOX_NMAX = 50;
    private static double[][][] w;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("DistLib.wilcox");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        w = new double[50][50][];
    }

    private static boolean checkSizesLarge(double m, double n) {
        if (m >= 50.0) {
            log.info((Object)"m should be less than %d\n50");
            return false;
        }
        if (n >= 50.0) {
            log.info((Object)"n should be less than %d\n50");
            return false;
        }
        return true;
    }

    private static void roundSizes(double m, double n) {
        m = Math.floor(m + 0.5);
        n = Math.floor(n + 0.5);
    }

    private static double cwilcox(int k, int m, int n) {
        int u = m * n;
        int c = u / 2;
        if (k < 0 || k > u) {
            return 0.0;
        }
        if (k > c) {
            k = u - k;
        }
        int i = m;
        int j = n;
        if (m >= n) {
            i = n;
            j = m;
        }
        if (w[i][j] == null) {
            wilcox.w[i][j] = new double[c + 1];
            int l = 0;
            while (l <= c) {
                wilcox.w[i][j][l] = -1.0;
                ++l;
            }
        }
        if (w[i][j][k] < 0.0) {
            wilcox.w[i][j][k] = i == 0 || j == 0 ? (k == 0 ? 1.0 : 0.0) : wilcox.cwilcox(k - n, m - 1, n) + wilcox.cwilcox(k, m, n - 1);
        }
        return w[i][j][k];
    }

    public static double density(double x2, double m, double n) {
        if (Double.isNaN(x2) || Double.isNaN(m) || Double.isNaN(n)) {
            return x2 + m + n;
        }
        wilcox.roundSizes(m, n);
        if (m <= 0.0 || n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (!wilcox.checkSizesLarge(m, n)) {
            return Double.NaN;
        }
        if ((x2 = Math.floor(x2 + 0.5)) < 0.0 || x2 > m * n) {
            return 0.0;
        }
        return wilcox.cwilcox((int)x2, (int)m, (int)n) / misc.choose(m + n, n);
    }

    public static double cumulative(double x2, double m, double n) {
        if (Double.isNaN(x2) || Double.isNaN(m) || Double.isNaN(n)) {
            return x2 + m + n;
        }
        if (Double.isInfinite(m) || Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        wilcox.roundSizes(m, n);
        if (m <= 0.0 || n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (!wilcox.checkSizesLarge(m, n)) {
            return Double.NaN;
        }
        if ((x2 = Math.floor(x2 + 0.5)) < 0.0) {
            return 0.0;
        }
        if (x2 >= m * n) {
            return 1.0;
        }
        double p = 0.0;
        int i = 0;
        while ((double)i <= x2) {
            p += wilcox.density(i, m, n);
            ++i;
        }
        return p;
    }

    public static double quantile(double x2, double m, double n) {
        if (Double.isNaN(x2) || Double.isNaN(m) || Double.isNaN(n)) {
            return x2 + m + n;
        }
        if (Double.isInfinite(x2) || Double.isInfinite(m) || Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        wilcox.roundSizes(m, n);
        if (x2 < 0.0 || x2 > 1.0 || m <= 0.0 || n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (!wilcox.checkSizesLarge(m, n)) {
            return Double.NaN;
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 == 1.0) {
            return m * n;
        }
        double p = 0.0;
        double q = 0.0;
        while (!((p += wilcox.density(q, m, n)) >= x2)) {
            q += 1.0;
        }
        return q;
    }

    public static double random(double m, double n) {
        if (Double.isNaN(m) || Double.isNaN(n)) {
            return m + n;
        }
        wilcox.roundSizes(m, n);
        if (m < 0.0 || n < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (m == 0.0 || n == 0.0) {
            return 0.0;
        }
        double r = 0.0;
        int k = (int)(m + n);
        int[] x2 = new int[k];
        int i = 0;
        while (i < k) {
            x2[i] = i;
            ++i;
        }
        i = 0;
        while ((double)i < n) {
            int j = (int)Math.floor((double)k * uniform.random());
            r += (double)x2[j];
            x2[j] = x2[--k];
            ++i;
        }
        return r - n * (n - 1.0) / 2.0;
    }
}

