/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.SnpSiftCmdFilterGt;

public class TestCasesFilterGt
extends TestCase {
    public static boolean verbose = false;

    public void test_01() {
        Gpr.debug("Test");
        String expression = "(GQ < 50) | (DP < 20)";
        SnpSiftCmdFilterGt gtfilter = new SnpSiftCmdFilterGt();
        List<VcfEntry> list2 = gtfilter.filter("test/testGtFilter01.vcf", expression, true);
        for (VcfEntry ve : list2) {
            if (verbose) {
                System.out.println(ve);
            }
            for (VcfGenotype gt : ve.getVcfGenotypes()) {
                String gtStr = gt.get("GT");
                String gqStr = gt.get("GQ");
                String dpStr = gt.get("DP");
                int gq = Gpr.parseIntSafe(gqStr);
                int dp = Gpr.parseIntSafe(dpStr);
                String filtered = "";
                if (gq < 50 | dp < 20) {
                    filtered = "FILTERED";
                    Assert.assertEquals("./.", gtStr);
                }
                if (!verbose) continue;
                System.out.println("\tGT: " + gtStr + " " + filtered + "\tGQ: " + gqStr + "\tDP: " + dpStr + "\t" + gt);
            }
        }
    }

    public void test_02() {
        Gpr.debug("Test");
        String expression = "(GQ < 50) | (DP < 20)";
        SnpSiftCmdFilterGt gtfilter = new SnpSiftCmdFilterGt();
        List<VcfEntry> list2 = gtfilter.filter("test/testGtFilter02.vcf", expression, true);
        for (VcfEntry ve : list2) {
            if (verbose) {
                System.out.println(ve);
            }
            for (VcfGenotype gt : ve.getVcfGenotypes()) {
                String gtStr = gt.get("GT");
                String gqStr = gt.get("GQ");
                String dpStr = gt.get("DP");
                int gq = Gpr.parseIntSafe(gqStr);
                int dp = Gpr.parseIntSafe(dpStr);
                String filtered = "";
                if (gq < 50 | dp < 20) {
                    filtered = "FILTERED";
                    Assert.assertEquals("./././.", gtStr);
                }
                if (!verbose) continue;
                System.out.println("\tGT: " + gtStr + " " + filtered + "\tGQ: " + gqStr + "\tDP: " + dpStr + "\t" + gt);
            }
        }
    }
}

