/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.sf.samtools.util.RuntimeEOFException;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBFileReader;
import org.snpeff.SnpEff;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.pdb.DistanceResult;
import org.snpeff.pdb.IdMapper;
import org.snpeff.pdb.IdMapperEntry;
import org.snpeff.pdb.PdbFile;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdPdb
extends SnpEff {
    public static final String DEFAULT_PDB_DIR = "db/pdb";
    public static final String DEFAULT_ID_MAP_FILE = "db/pdb/idMap_pdbId_ensemblId_refseqId.txt.gz";
    public static final String DEFAULT_INTERACT_FILE = "db/pdb/pdbCompoundLines.txt";
    public static final String PDB_EXT = ".ent";
    public static final String PDB_EXT_GZ = ".ent.gz";
    public static final String[] PDB_EXTS = new String[]{".ent.gz", ".ent"};
    public static final String PROTEIN_INTERACTION_FILE = "interactions.bin";
    public static final String UNIPROT_DATABASE = "UNP";
    public static final double DEFAULT_DISTANCE_THRESHOLD = 3.0;
    public static final double DEFAULT_MAX_MISMATCH_RATE = 0.1;
    public static final int DEFAULT_PDB_MIN_AA_SEPARATION = 20;
    public static final String DEFAULT_PDB_ORGANISM_COMMON = "HUMAN";
    public static final String DEFAULT_PDB_ORGANISM_SCIENTIFIC = "HOMO SAPIENS";
    public static final double DEFAULT_PDB_RESOLUTION = 3.0;
    public static final ArrayList<DistanceResult> EMPTY_DISTANCES = new ArrayList();
    String idMapFile = "db/pdb/idMap_pdbId_ensemblId_refseqId.txt.gz";
    String interactListFile = "db/pdb/idMap_pdbId_ensemblId_refseqId.txt.gz";
    String pdbDir = "db/pdb";
    String pdbOrganismCommon = "HUMAN";
    String pdbOrganismScientific = "HOMO SAPIENS";
    double pdbResolution = 3.0;
    double maxMismatchRate = 0.1;
    double distanceThreshold = 3.0;
    double distanceThresholdNon = Double.POSITIVE_INFINITY;
    int aaMinSeparation = 20;
    int countFilesPass;
    int countMapError;
    int countMapOk;
    IdMapper idMapper;
    IdMapper idMapperConfirmed;
    PDBFileReader pdbreader;
    Set<String> confirmedPdbChainsMappings;
    Map<String, Transcript> trancriptById;
    Collection<String> pdbFileNames;
    BufferedWriter outpufFile;
    Set<String> saved;
    List<DistanceResult> distanceResults;

    String aaSequence(Chain chain2) {
        List<AminoAcid> aas = this.aminoAcids(chain2);
        StringBuilder sb = new StringBuilder();
        for (AminoAcid aa1 : aas) {
            sb.append(aa1.getAminoType());
        }
        return sb.toString();
    }

    List<AminoAcid> aminoAcids(Chain chain2) {
        ArrayList<AminoAcid> aas = new ArrayList<AminoAcid>();
        for (Group group : chain2.getAtomGroups()) {
            if (!(group instanceof AminoAcid)) continue;
            aas.add((AminoAcid)group);
        }
        return aas;
    }

    Map<String, String> chainUniprotIds(Structure pdbStruct) {
        HashMap<String, String> chain2uniproId = new HashMap<String, String>();
        for (DBRef dbref : pdbStruct.getDBRefs()) {
            if (this.debug) {
                Gpr.debug("PDB_DBREF\tchain:" + dbref.getChainId() + "\tdb: " + dbref.getDatabase() + "\tID: " + dbref.getDbAccession());
            }
            if (!dbref.getDatabase().equals(UNIPROT_DATABASE)) continue;
            chain2uniproId.put(dbref.getChainId(), dbref.getDbAccession());
        }
        return chain2uniproId;
    }

    List<IdMapperEntry> checkSequencePdbGenome(Structure pdbStruct, Chain chain2, String trId, List<IdMapperEntry> idmapsOri) {
        ArrayList<IdMapperEntry> idmapsNew = new ArrayList<IdMapperEntry>();
        String pdbId = pdbStruct.getPDBCode();
        if (!this.filterPdbChain(chain2)) {
            return idmapsNew;
        }
        Transcript tr = this.trancriptById.get(trId);
        String prot = tr.protein();
        if (this.debug) {
            System.err.println("\tTranscript ID: " + tr.getId() + "\tProtein [" + prot.length() + "]: " + prot);
        }
        StringBuilder sb = new StringBuilder();
        int countMatch = 0;
        int countMismatch = 0;
        for (Group group : chain2.getAtomGroups()) {
            AminoAcid aa;
            int aaPos;
            if (!(group instanceof AminoAcid) || (aaPos = (aa = (AminoAcid)group).getResidueNumber().getSeqNum() - 1) < 0) continue;
            char aaLetter = aa.getChemComp().getOne_letter_code().charAt(0);
            if (prot.length() > aaPos) {
                char trAaLetter = prot.charAt(aaPos);
                if (aaLetter == trAaLetter) {
                    ++countMatch;
                } else {
                    ++countMismatch;
                }
            } else {
                ++countMismatch;
            }
            sb.append(aa.getChemComp().getOne_letter_code());
        }
        if (countMatch + countMismatch > 0) {
            double err2 = (double)countMismatch / (double)(countMatch + countMismatch);
            if (this.debug) {
                Gpr.debug("\tChain: " + chain2.getChainID() + "\terror: " + err2 + "\t" + sb);
            }
            if (err2 < this.maxMismatchRate) {
                if (this.debug) {
                    Gpr.debug("\tMapping OK    :\t" + trId + "\terror: " + err2);
                }
                int trAaLen = tr.protein().length();
                int pdbAaLen = chain2.getAtomGroups("amino").size();
                for (IdMapperEntry idm : idmapsOri) {
                    if (!trId.equals(idm.trId) || !pdbId.equals(idm.pdbId)) continue;
                    idmapsNew.add(idm.cloneAndSet(chain2.getChainID(), pdbAaLen, trAaLen));
                    break;
                }
            } else if (this.debug) {
                Gpr.debug("\tMapping ERROR :\t" + trId + "\terror: " + err2);
            }
        }
        return idmapsNew;
    }

    List<IdMapperEntry> checkSequencePdbGenome(Structure pdbStruct, Set<String> trIds) {
        ArrayList<IdMapperEntry> list2 = new ArrayList<IdMapperEntry>();
        for (String trId : trIds) {
            if (!this.filterTranscript(trId)) continue;
            list2.addAll(this.checkSequencePdbGenome(pdbStruct, trId));
        }
        return list2;
    }

    List<IdMapperEntry> checkSequencePdbGenome(Structure pdbStruct, String trId) {
        String pdbId = pdbStruct.getPDBCode();
        if (this.debug) {
            System.err.println("\nChecking '" + trId + "'\t<->\t'" + pdbStruct.getPDBCode() + "'");
        }
        List<IdMapperEntry> idmapsOri = this.idMapper.getByPdbId(pdbId);
        ArrayList<IdMapperEntry> idmapsNew = new ArrayList<IdMapperEntry>();
        for (Chain chain2 : pdbStruct.getChains()) {
            idmapsNew.addAll(this.checkSequencePdbGenome(pdbStruct, chain2, trId, idmapsOri));
        }
        if (this.debug) {
            for (IdMapperEntry ime : idmapsNew) {
                Gpr.debug(ime);
            }
        }
        return idmapsNew;
    }

    void closeOuptut() {
        try {
            if (this.outpufFile != null) {
                this.outpufFile.close();
            }
            this.outpufFile = null;
            this.saved = null;
        }
        catch (IOException e) {
            throw new RuntimeEOFException("Error closing output file", e);
        }
    }

    void createTranscriptMap() {
        this.trancriptById = new HashMap<String, Transcript>();
        for (Gene g : this.config.getSnpEffectPredictor().getGenome().getGenes()) {
            for (Transcript tr : g) {
                String trId = IdMapper.transcriptIdNoVersion(tr.getId());
                this.trancriptById.put(trId, tr);
            }
        }
    }

    void deleteOuptut(String outputPdbFile) {
        File of = new File(outputPdbFile);
        of.delete();
    }

    double distanceMin(AminoAcid aa1, AminoAcid aa2) {
        double distMin = Double.POSITIVE_INFINITY;
        for (Atom atom1 : aa1.getAtoms()) {
            for (Atom atom2 : aa2.getAtoms()) {
                try {
                    double dist = Calc.getDistance(atom1, atom2);
                    distMin = Math.min(distMin, dist);
                }
                catch (StructureException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return distMin;
    }

    String fileName2PdbId(String pdbFileName) {
        String base = Gpr.baseName(pdbFileName);
        if (base.startsWith("pdb")) {
            base = base.substring(3);
        }
        base = Gpr.removeExt(base, PDB_EXTS);
        return base.toUpperCase();
    }

    boolean filterPdb(Structure pdbStruct) {
        double res = pdbStruct.getPDBHeader().getResolution();
        if (res > this.pdbResolution) {
            if (this.debug) {
                Gpr.debug("PDB resolution is " + res + ", ignoring file");
            }
            return false;
        }
        boolean ok = false;
        for (Chain chain2 : pdbStruct.getChains()) {
            ok |= this.filterPdbChain(chain2);
        }
        return ok;
    }

    boolean filterPdbChain(Chain chain2) {
        if (chain2.getHeader() == null) {
            return false;
        }
        String orgs = chain2.getHeader().getOrganismScientific();
        if (orgs != null && orgs.indexOf(this.pdbOrganismScientific) >= 0) {
            return true;
        }
        orgs = chain2.getHeader().getOrganismCommon();
        if (orgs == null) {
            return false;
        }
        if (orgs.indexOf(32) > 0) {
            for (String org : orgs.split("\\s")) {
                if (!org.equals(this.pdbOrganismCommon)) continue;
                return true;
            }
        }
        return orgs.equals(this.pdbOrganismCommon);
    }

    boolean filterTranscript(String trId) {
        Transcript tr = this.trancriptById.get(trId);
        if (tr == null) {
            if (this.debug) {
                Gpr.debug("Transcript '" + trId + "' not found in " + this.genomeVer + ".");
            }
            return false;
        }
        return true;
    }

    List<DistanceResult> findInteractingCompound(Structure pdbStruct, Chain chain1, Chain chain2, String trId1, String trId2) {
        ArrayList<DistanceResult> results = new ArrayList<DistanceResult>();
        Transcript tr1 = this.getTranscript(trId1);
        Transcript tr2 = this.getTranscript(trId2);
        List<AminoAcid> aas1 = this.aminoAcids(chain1);
        List<AminoAcid> aas2 = this.aminoAcids(chain2);
        for (AminoAcid aa1 : aas1) {
            for (AminoAcid aa2 : aas2) {
                double dmin = this.distanceMin(aa1, aa2);
                if (!this.select(dmin)) continue;
                DistanceResult dres = new DistanceResult(aa1, aa2, tr1, tr2, dmin);
                if (dres.hasValidCoords()) {
                    results.add(dres);
                    ++this.countMapOk;
                    if (!this.debug) continue;
                    Gpr.debug((dmin <= this.distanceThreshold ? "AA_IN_CONTACT\t" : "AA_NOT_IN_CONTACT\t") + dres);
                    continue;
                }
                ++this.countMapError;
            }
        }
        return results;
    }

    List<DistanceResult> findInteractingSingle(Chain chain2, Transcript tr) {
        ArrayList<DistanceResult> results = new ArrayList<DistanceResult>();
        List<AminoAcid> aas = this.aminoAcids(chain2);
        for (int i = 0; i < aas.size(); ++i) {
            int minj;
            for (int j = minj = i + this.aaMinSeparation; j < aas.size(); ++j) {
                AminoAcid aa2;
                AminoAcid aa1 = aas.get(i);
                double d = this.distanceMin(aa1, aa2 = aas.get(j));
                if (!this.select(d)) continue;
                DistanceResult dres = new DistanceResult(aa1, aa2, tr, tr, d);
                if (dres.hasValidCoords()) {
                    results.add(dres);
                    ++this.countMapOk;
                    if (!this.debug) continue;
                    Gpr.debug((d <= this.distanceThreshold ? "AA_IN_CONTACT\t" : "AA_NOT_IN_CONTACT\t") + dres);
                    continue;
                }
                ++this.countMapError;
            }
        }
        return results;
    }

    List<DistanceResult> findInteractingSingle(Structure structure, Transcript tr) {
        ArrayList<DistanceResult> results = new ArrayList<DistanceResult>();
        for (Chain chain2 : structure.getChains()) {
            if (!this.filterPdbChain(chain2)) continue;
            results.addAll(this.findInteractingSingle(chain2, tr));
        }
        return results;
    }

    Collection<String> findPdbFiles() {
        return this.findPdbFiles(new File(this.pdbDir));
    }

    Collection<String> findPdbFiles(File dir) {
        if (this.debug) {
            Gpr.debug("Finding PDB files in directory: " + dir);
        }
        LinkedList<String> list2 = new LinkedList<String>();
        if (!dir.isDirectory()) {
            throw new RuntimeException("No such directory '" + dir + "'");
        }
        for (File f2 : dir.listFiles()) {
            String fileName = f2.getName();
            if (f2.isDirectory()) {
                list2.addAll(this.findPdbFiles(f2));
                continue;
            }
            if (!f2.isFile() || !fileName.endsWith(PDB_EXT) && !fileName.endsWith(PDB_EXT_GZ)) continue;
            list2.add(f2.getAbsolutePath());
            if (!this.debug) continue;
            Gpr.debug("Found PDB file: " + f2.getAbsolutePath());
        }
        return list2;
    }

    Set<String> findTranscriptIds(String pdbId) {
        List<IdMapperEntry> idEntries = this.idMapper.getByPdbId(pdbId);
        Set<String> trIds = IdMapper.transcriptIds(idEntries);
        if (this.debug) {
            StringBuilder sb = new StringBuilder();
            sb.append("PDB ID: " + pdbId);
            sb.append("\tEntries:\n");
            if (idEntries != null) {
                for (IdMapperEntry ime : idEntries) {
                    sb.append("\t\t" + ime + "\n");
                }
                sb.append("\tTranscripts:\t" + trIds + "\n");
            }
            Gpr.debug(sb);
        }
        return trIds;
    }

    public List<DistanceResult> getDistanceResults() {
        return this.distanceResults;
    }

    Transcript getTranscript(String trId) {
        return this.trancriptById.get(IdMapper.transcriptIdNoVersion(trId));
    }

    List<IdMapperEntry> idMapChain(Structure pdbStruct, Chain chain2, List<IdMapperEntry> idMaps) {
        ArrayList<IdMapperEntry> idMapChain = new ArrayList<IdMapperEntry>();
        for (IdMapperEntry idmap : idMaps) {
            if (!idmap.pdbId.equals(pdbStruct.getPDBCode()) || !idmap.pdbChainId.equals(chain2.getChainID())) continue;
            idMapChain.add(idmap);
        }
        return idMapChain;
    }

    public void initialize() {
        String[] argsSnpEff = new String[]{"eff", "-c", this.configFile, this.genomeVer};
        this.args = argsSnpEff;
        this.setGenomeVer(this.genomeVer);
        this.parseArgs(argsSnpEff);
        this.loadConfig();
        if (this.genomeVer != null) {
            Timer.showStdErr("Loading SnpEff's database: " + this.genomeVer);
            this.loadDb();
            Timer.showStdErr("Done.");
        }
        this.trancriptById = new HashMap<String, Transcript>();
        for (Gene g : this.config.getSnpEffectPredictor().getGenome().getGenes()) {
            for (Transcript tr : g) {
                String id = tr.getId();
                if (id.indexOf(46) > 0) {
                    id = id.substring(0, id.indexOf(46));
                }
                if (this.trancriptById.containsKey(id)) {
                    String chrPrev = this.trancriptById.get(id).getChromosomeName();
                    String chr = tr.getChromosomeName();
                    if (chr.length() >= chrPrev.length()) continue;
                    this.trancriptById.put(id, tr);
                    continue;
                }
                this.trancriptById.put(id, tr);
            }
        }
        this.pdbreader = new PDBFileReader();
    }

    boolean isCompound(Structure pdbStruct) {
        List<Compound> compounds = pdbStruct.getCompounds();
        return compounds != null && !compounds.isEmpty();
    }

    public void loadIdMapper() {
        if (this.verbose) {
            Timer.showStdErr("Loading id maps " + this.idMapFile);
        }
        this.idMapper = new IdMapper();
        this.idMapper.setVerbose(this.verbose);
        this.idMapper.load(this.idMapFile);
    }

    void openOuptut(String outputPdbFile) {
        try {
            if (this.verbose) {
                Timer.showStdErr("Saving results to database file '" + outputPdbFile + "'");
            }
            this.outpufFile = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(new File(outputPdbFile)))));
            this.saved = new HashSet<String>();
        }
        catch (IOException e) {
            throw new RuntimeEOFException("Error opening output file '" + outputPdbFile + "'", e);
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args == null) {
            return;
        }
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                arg = arg.toLowerCase();
                switch (arg.toLowerCase()) {
                    case "-aasep": {
                        if (i + 1 < args.length) {
                            this.aaMinSeparation = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Missing parameter in '-aaSep'");
                        break;
                    }
                    case "-idmap": {
                        if (i + 1 < args.length) {
                            this.idMapFile = args[++i];
                            break;
                        }
                        this.usage("Missing parameter in '-idMap'");
                        break;
                    }
                    case "-interactlist": {
                        if (i + 1 < args.length) {
                            this.idMapFile = args[++i];
                            break;
                        }
                        this.usage("Missing parameter in '-interactList'");
                        break;
                    }
                    case "-maxdist": {
                        if (i + 1 < args.length) {
                            this.distanceThreshold = Gpr.parseDoubleSafe(args[++i]);
                            break;
                        }
                        this.usage("Missing parameter in '-maxDist'");
                        break;
                    }
                    case "-maxerr": {
                        if (i + 1 < args.length) {
                            this.maxMismatchRate = Gpr.parseDoubleSafe(args[++i]);
                            break;
                        }
                        this.usage("Missing parameter: '-maxErr'");
                        break;
                    }
                    case "-org": {
                        if (i + 1 < args.length) {
                            this.pdbOrganismCommon = args[++i].toUpperCase();
                            break;
                        }
                        this.usage("Missing parameter in '-org'");
                        break;
                    }
                    case "-orgscientific": {
                        if (i + 1 < args.length) {
                            this.pdbOrganismScientific = args[++i].toUpperCase();
                            break;
                        }
                        this.usage("Missing parameter in '-orgScientific'");
                        break;
                    }
                    case "-pdbdir": {
                        if (i + 1 < args.length) {
                            this.pdbDir = args[++i];
                            break;
                        }
                        this.usage("Missing parameter in '-pdbDir'");
                        break;
                    }
                    case "-res": {
                        if (i + 1 < args.length) {
                            this.pdbResolution = Gpr.parseDoubleSafe(args[++i]);
                            break;
                        }
                        this.usage("Missing parameter: '-res'");
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer != null && !this.genomeVer.isEmpty()) continue;
            this.genomeVer = arg;
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.distanceThreshold <= 0.0) {
            this.usage("Max distance in '-maxdist' command line option must be a positive number");
        }
        if (this.maxMismatchRate <= 0.0) {
            this.usage("Max mismatch rate in '-maxErr' command line option must be a positive number");
        }
        if (this.pdbResolution <= 0.0) {
            this.usage("Resoluton in '-res' command line option must be a positive number");
        }
        if (this.aaMinSeparation <= 0) {
            this.usage("Minimum separation in '-aaSep' command line option must be a positive, integer number");
        }
    }

    public void pdb() {
        if (this.verbose) {
            Timer.showStdErr("Finding PDB files");
        }
        this.pdbFileNames = this.findPdbFiles();
        this.createTranscriptMap();
        if (this.verbose) {
            Timer.showStdErr("Analyzing PDB sequences");
        }
        this.pdbAnalysis();
        this.closeOuptut();
    }

    protected void pdbAnalysis() {
        if (this.verbose) {
            Timer.showStdErr("Analyzing PDB files");
        }
        for (String pdbFileName : this.pdbFileNames) {
            this.pdbAnalysis(pdbFileName);
        }
        if (this.verbose) {
            Timer.showStdErr("Done.\n\tNumber of PDB files : " + this.pdbFileNames.size() + "\n\tPDB files analyzed  : " + this.countFilesPass + "\n\tAA 'in contact'     : " + this.countMapOk + "\n\tMapping errors      : " + this.countMapError);
        }
    }

    protected void pdbAnalysis(String pdbFileName) {
        String pdbId = this.fileName2PdbId(pdbFileName);
        Set<String> trIds = this.findTranscriptIds(pdbId);
        if (trIds == null || trIds.isEmpty()) {
            if (this.debug) {
                Gpr.debug("No transcript IDs found for PDB entry '" + pdbId + "'");
            }
            return;
        }
        Structure pdbStruct = this.readPdbFile(pdbFileName);
        if (pdbStruct == null || !this.filterPdb(pdbStruct)) {
            return;
        }
        this.pdbAnalysisSingle(pdbStruct, trIds);
        if (this.isCompound(pdbStruct)) {
            this.pdbAnalysisCompound(pdbStruct, trIds);
        }
    }

    void pdbAnalysisCompound(Structure pdbStruct, Set<String> trIds) {
        ++this.countFilesPass;
        List<IdMapperEntry> idMapConfirmed = this.checkSequencePdbGenome(pdbStruct, trIds);
        if (idMapConfirmed == null || idMapConfirmed.isEmpty()) {
            return;
        }
        Map<String, String> chain2uniproId = this.chainUniprotIds(pdbStruct);
        for (Chain chain1 : pdbStruct.getChains()) {
            String chainId1 = chain1.getChainID();
            List<IdMapperEntry> idMapChain1 = this.idMapChain(pdbStruct, chain1, idMapConfirmed);
            if (idMapChain1.isEmpty()) {
                if (!this.debug) continue;
                Gpr.debug("Empty maps for chain '" + chainId1 + "'");
                continue;
            }
            for (Chain chain2 : pdbStruct.getChains()) {
                String chainId2 = chain2.getChainID();
                if (chainId1.compareTo(chainId2) >= 0) continue;
                String uniprot1 = chain2uniproId.get(chainId1);
                String uniprot2 = chain2uniproId.get(chainId2);
                if (uniprot1 != null && uniprot2 != null && uniprot1.equals(uniprot2)) {
                    if (!this.debug) continue;
                    Gpr.debug("Filtering out two chains with same UNIPROT ID: '" + uniprot1);
                    continue;
                }
                List<IdMapperEntry> idMapChain2 = this.idMapChain(pdbStruct, chain2, idMapConfirmed);
                if (idMapChain2.isEmpty()) {
                    if (!this.debug) continue;
                    Gpr.debug("Empty maps for chain '" + chainId2 + "'");
                    continue;
                }
                for (IdMapperEntry im1 : idMapChain1) {
                    for (IdMapperEntry im2 : idMapChain2) {
                        if (im1.trId.equals(im2.trId)) continue;
                        List<DistanceResult> dres = this.findInteractingCompound(pdbStruct, chain1, chain2, im1.trId, im2.trId);
                        this.save(dres);
                    }
                }
            }
        }
    }

    void pdbAnalysisSingle(Structure pdbStruct, Set<String> trIds) {
        ++this.countFilesPass;
        List<IdMapperEntry> idMapConfirmed = this.checkSequencePdbGenome(pdbStruct, trIds);
        if (idMapConfirmed == null || idMapConfirmed.isEmpty()) {
            return;
        }
        for (IdMapperEntry idmap : idMapConfirmed) {
            Transcript tr = this.getTranscript(idmap.trId);
            List<DistanceResult> dres = this.findInteractingSingle(pdbStruct, tr);
            this.save(dres);
        }
    }

    public Structure readPdbFile(String pdbFileName) {
        try {
            PdbFile pdbreader = new PdbFile();
            if (this.verbose) {
                Timer.showStdErr("Reading PDB file: " + pdbFileName);
            }
            return pdbreader.getStructure(pdbFileName);
        }
        catch (IOException e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public boolean run() {
        this.loadIdMapper();
        this.loadConfig();
        String outputPdbFile = this.config.getDirDataGenomeVersion() + "/" + PROTEIN_INTERACTION_FILE;
        this.deleteOuptut(outputPdbFile);
        this.loadDb();
        this.openOuptut(outputPdbFile);
        this.pdb();
        return true;
    }

    public boolean run(boolean storeResults) {
        this.distanceResults = new ArrayList<DistanceResult>();
        this.run();
        return true;
    }

    void save(List<DistanceResult> distResults) {
        for (DistanceResult d : distResults) {
            try {
                String dstr = d.toString();
                if (this.saved.contains(dstr)) continue;
                this.outpufFile.write(dstr + "\n");
                this.saved.add(dstr);
                if (this.distanceResults == null) continue;
                this.distanceResults.add(d);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    boolean select(double d) {
        if (!Double.isInfinite(this.distanceThreshold)) {
            return d <= this.distanceThreshold;
        }
        if (!Double.isInfinite(this.distanceThresholdNon)) {
            return d > this.distanceThresholdNon;
        }
        throw new RuntimeException("Neither distance is finite!");
    }

    public void setDistanceThresholdNon(double distanceThresholdNon) {
        this.distanceThresholdNon = distanceThresholdNon;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
            System.err.println("Command line :\t" + this.commandLineStr(false) + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff pdb [options] genome_version");
        System.err.println("\n");
        System.err.println("\nOptions:");
        System.err.println("\t-aaSep <number>                 : Minimum number of AA of separation within the sequence. Default: " + this.aaMinSeparation);
        System.err.println("\t-idMap <file>                   : ID map file (i.e. file containing mapping from PDB ID to transcript ID). Default: " + this.idMapFile);
        System.err.println("\t-interactList <file>            : A file containing protein-protein interations (from PDB co-srystalzed structures). Default: " + this.interactListFile);
        System.err.println("\t-maxDist <number>               : Maximum distance in Angtrom for any atom in a pair of amino acids to be considered 'in contact'. Default: " + this.distanceThreshold);
        System.err.println("\t-maxErr <number>                : Maximum amino acid sequence differece between PDB file and genome. Default: " + this.maxMismatchRate);
        System.err.println("\t-org <name>                     : Organism 'common name'. Default: " + this.pdbOrganismCommon);
        System.err.println("\t-orgScientific <name>           : Organism 'scientific name'. Default: " + this.pdbOrganismScientific);
        System.err.println("\t-pdbDir <path>                  : Path to PDB files (files in all sub-dirs are scanned).");
        System.err.println("\t-res <number>                   : Maximum PDB file resolution. Default: " + this.pdbResolution);
        this.usageGenericAndDb();
        System.exit(-1);
    }
}

