/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.snpeff.SnpEff;
import org.snpeff.logStatsServer.VersionCheck;
import org.snpeff.util.Download;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdDownload
extends SnpEff {
    boolean update;

    void downloadAndInstall(URL url, String localFile) {
        Download download = new Download();
        download.setVerbose(this.verbose);
        download.setDebug(this.debug);
        download.setUpdate(this.update);
        if (download.download(url, localFile) && download.unzip(localFile, this.config.getDirMain(), this.config.getDirData())) {
            if (this.verbose) {
                Timer.showStdErr("Unzip: OK");
            }
            if (new File(localFile).delete() && this.verbose) {
                Timer.showStdErr("Deleted local file '" + localFile + "'");
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (this.isOpt(args[i])) {
                this.usage("Unknown option '" + args[i] + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
                continue;
            }
            this.usage("Unknown parameter '" + args[i] + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    @Override
    public boolean run() {
        if (this.genomeVer.equals("snpeff")) {
            this.update = true;
            return this.runDownloadSnpEff();
        }
        return this.runDownloadGenome();
    }

    boolean runDownloadGenome() {
        this.loadConfig();
        if (this.verbose) {
            Timer.showStdErr("Downloading database for '" + this.genomeVer + "'");
        }
        URL url = this.config.downloadUrl(this.genomeVer);
        String localFile = System.getProperty("java.io.tmpdir") + "/" + Download.urlBaseName(url.toString());
        this.downloadAndInstall(url, localFile);
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        return true;
    }

    boolean runDownloadSnpEff() {
        URL url;
        this.genomeVer = "";
        this.loadConfig();
        VersionCheck versionCheck = VersionCheck.version("SnpEff", "4.3t", this.config.getVersionsUrl(), this.verbose);
        if (!versionCheck.isNewVersion()) {
            Timer.showStdErr("No new version found. This seems to be the latest version (" + versionCheck.getLatestVersion() + ") or server could not be contacted. Nothing done.");
            return false;
        }
        Timer.showStdErr("New version: \n\tNew version  : " + versionCheck.getLatestVersion() + "\n\tRelease date : " + versionCheck.getLatestReleaseDate() + "\n\tDownload URL : " + versionCheck.getLatestUrl());
        if (this.verbose) {
            Timer.showStdErr("Downloading SnpEff");
        }
        try {
            url = new URL(versionCheck.getLatestUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String localFile = System.getProperty("java.io.tmpdir") + "/" + Gpr.baseName(url.toString());
        this.downloadAndInstall(url, localFile);
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff download [options] {snpeff | genome_version}");
        System.exit(-1);
    }
}

