/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.ped;

import java.io.IOException;
import org.snpeff.fileIterator.FileIterator;
import org.snpeff.ped.PedEntry;
import org.snpeff.ped.PlinkMap;

public class PedFileIterator
extends FileIterator<PedEntry> {
    PlinkMap plinkMap = new PlinkMap();

    public PedFileIterator(String fileName, String mapFileName) {
        super(fileName);
        this.plinkMap.read(mapFileName);
    }

    public PlinkMap getPlinkMap() {
        return this.plinkMap;
    }

    PedEntry parseLine(String line) {
        return new PedEntry(this.plinkMap, line);
    }

    @Override
    protected PedEntry readNext() {
        block5: {
            try {
                if (!this.reader.ready()) break block5;
                this.line = this.reader.readLine();
                if (this.line == null) break block5;
                ++this.lineNum;
                try {
                    PedEntry pedEntry = this.parseLine(this.line);
                    if (pedEntry != null) {
                        return pedEntry;
                    }
                }
                catch (Throwable t2) {
                    throw new RuntimeException("Error parsing line from PED/TFAM file:\n\tFile name : '" + this.fileName + "'\n\tLine number : " + this.lineNum + "\n\tLine: '" + this.line + "'", t2);
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

