/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.Collections;
import java.util.List;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.Exon;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Utr;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.GprSeq;

public class Utr5prime
extends Utr {
    private static final long serialVersionUID = 3710420226746056364L;
    List<Utr5prime> utrs;

    public Utr5prime() {
        this.type = EffectType.UTR_5_PRIME;
    }

    public Utr5prime(Exon parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.UTR_5_PRIME;
    }

    synchronized List<Utr5prime> get5primeUtrs() {
        if (this.utrs == null) {
            Transcript tr = (Transcript)this.findParent(Transcript.class);
            this.utrs = tr.get5primeUtrs();
            if (this.isStrandPlus()) {
                Collections.sort(this.utrs, new IntervalComparatorByStart());
            } else {
                Collections.sort(this.utrs, new IntervalComparatorByEnd(true));
            }
        }
        return this.utrs;
    }

    public String getSequence() {
        StringBuffer sb = new StringBuffer();
        for (Utr5prime utr : this.get5primeUtrs()) {
            Exon ex = (Exon)utr.getParent();
            String utrSeq = ex.getSequence();
            if (utr.size() < utrSeq.length()) {
                utrSeq = utrSeq.substring(0, utr.size());
            }
            sb.append(utrSeq);
        }
        return sb.toString();
    }

    @Override
    public boolean isUtr3prime() {
        return false;
    }

    @Override
    public boolean isUtr5prime() {
        return true;
    }

    String startGained(char[] chars, int pos) {
        CodonTable ctable = CodonTables.getInstance().getTable(this.getGenome(), this.getChromosomeName());
        for (int i = Math.max(0, pos - 2); i <= pos && i + 2 < chars.length; ++i) {
            String codon = "" + chars[i] + chars[i + 1] + chars[i + 2];
            if (!ctable.isStart(codon)) continue;
            return codon.toUpperCase();
        }
        return "";
    }

    String startGained(Variant seqChange, Transcript tr) {
        if (!seqChange.isSnp()) {
            return "";
        }
        int pos = seqChange.distanceBases(this.get5primeUtrs(), this.isStrandMinus());
        String sequence2 = this.getSequence();
        char[] chars = sequence2.toCharArray();
        char snpBase = seqChange.netChange(this).charAt(0);
        if (this.isStrandMinus()) {
            snpBase = GprSeq.wc(snpBase);
        }
        chars[pos] = snpBase;
        return this.startGained(chars, pos);
    }

    @Override
    int utrDistance(Variant variant, Transcript tr) {
        int cdsStart = tr.getCdsStart();
        if (cdsStart < 0) {
            return -1;
        }
        if (this.isStrandPlus()) {
            return cdsStart - variant.getEnd();
        }
        return variant.getStart() - cdsStart;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (variant.includes(this) && variant.getVariantType() == Variant.VariantType.DEL) {
            variantEffects.add(variant, this, EffectType.UTR_5_DELETED, "");
            return true;
        }
        Transcript tr = (Transcript)this.findParent(Transcript.class);
        int distance = this.utrDistance(variant, tr);
        VariantEffect variantEffect = new VariantEffect(variant);
        variantEffect.set(this, this.type, this.type.effectImpact(), distance >= 0 ? distance + " bases from TSS" : "");
        variantEffect.setDistance(distance);
        variantEffects.add(variantEffect);
        String gained = this.startGained(variant, tr);
        if (!gained.isEmpty()) {
            variantEffects.add(variant, this, EffectType.START_GAINED, gained);
        }
        return true;
    }
}

