/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.bio.structure.server.FlatFileInstallation;

public class PrepareIndexFile {
    private static final SimpleDateFormat dateFormat = FlatFileInstallation.dateFormat;

    public void prepareIndexFileForInstallation(FlatFileInstallation installation) throws FileNotFoundException, IOException {
        File[] pdbfiles = this.getAllPDB(installation.getFilePath());
        this.createPDBInfoList(pdbfiles, installation.getPDBInfoFile(), installation.getChainInfoFile());
    }

    public void createPDBInfoList(File[] pdbfiles, File outputFile, File chainInfoFile) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(outputFile);
        PrintStream p = new PrintStream(out);
        PrintWriter pdbWriter = new PrintWriter(p);
        FileOutputStream cout = new FileOutputStream(chainInfoFile);
        PrintStream pc = new PrintStream(cout);
        PrintWriter chainWriter = new PrintWriter(pc);
        PDBFileReader pdbreader = new PDBFileReader();
        this.logPDBInfoFile(pdbWriter, chainWriter, pdbreader, pdbfiles);
    }

    protected void logPDBInfoFile(PrintWriter pdbWriter, PrintWriter chainWriter, StructureIOFile pdbreader, File[] pdbfiles) throws IOException {
        pdbWriter.println("//pdbId\tnrCAAtoms\ttechnique\tresolution\tdepDate\tmodDate\ttitle\tclassification\ttime\tpath");
        chainWriter.println("//pdbId\tchainId\tseqResLength\tatomLength\taminoLength\thetLength\tnucleotideLength\tmolName\tmolId\tdbrefs");
        int l = pdbfiles.length;
        long loopStart = System.currentTimeMillis();
        for (int i = 0; i < l; ++i) {
            File f2 = pdbfiles[i];
            long startTime = System.currentTimeMillis();
            System.out.println("# " + i + " / " + l + " " + f2);
            Structure s = null;
            s = pdbreader.getStructure(f2);
            long stopTime = System.currentTimeMillis();
            this.logPDBInfo(pdbWriter, s, startTime, stopTime, f2);
            this.logChainInfo(chainWriter, s);
        }
        long loopEnd = System.currentTimeMillis();
        pdbWriter.flush();
        pdbWriter.close();
        chainWriter.flush();
        chainWriter.close();
        long time = (loopEnd - loopStart) / 60000L;
        System.out.println("loop took: " + time + " minutes");
    }

    private Compound getCompoundForChain(List<Compound> compounds, Chain c) {
        for (Compound comp : compounds) {
            List<String> chainIds = comp.getChainId();
            if (chainIds == null || !chainIds.contains(c.getChainID())) continue;
            return comp;
        }
        return null;
    }

    private String getDBRefStringForChain(List<DBRef> dbrefs, Chain c) {
        ArrayList<String> dbIds = new ArrayList<String>();
        for (DBRef dbref : dbrefs) {
            if (!dbref.getChainId().equals(c.getChainID())) continue;
            dbIds.add(dbref.getDbIdCode());
        }
        StringBuffer buf = new StringBuffer();
        int pos = 1;
        for (String id : dbIds) {
            buf.append(id);
            if (pos >= dbIds.size()) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private void logChainInfo(PrintWriter chainWriter, Structure s) {
        String pdbCode = s.getPDBCode();
        List<Chain> chains = s.getChains(0);
        List<Compound> compounds = s.getCompounds();
        List<DBRef> dbrefs = s.getDBRefs();
        for (Chain c : chains) {
            List<Group> agr = c.getAtomGroups("amino");
            List<Group> hgr = c.getAtomGroups("hetatm");
            List<Group> ngr = c.getAtomGroups("nucleotide");
            Compound comp = this.getCompoundForChain(compounds, c);
            String molName = "-";
            String molId = "-";
            if (comp != null) {
                molName = comp.getMolName();
                molId = comp.getMolId();
            }
            String dbRefString = this.getDBRefStringForChain(dbrefs, c);
            String str = String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t", pdbCode, c.getChainID(), c.getSeqResLength(), c.getAtomLength(), agr.size(), hgr.size(), ngr.size(), molName, molId, dbRefString);
            chainWriter.println(str);
        }
    }

    private void logPDBInfo(PrintWriter pdbWriter, Structure s, long startTime, long stopTime, File path) {
        if (s.isNmr()) {
            List<Chain> chains = s.getModel(0);
            StructureImpl newsubject = new StructureImpl();
            newsubject.setPDBCode(s.getPDBCode());
            newsubject.setHeader(s.getHeader());
            newsubject.setPDBHeader(s.getPDBHeader());
            newsubject.setDBRefs(s.getDBRefs());
            newsubject.addModel(chains);
            newsubject.setNmr(true);
            s = newsubject;
        }
        Atom[] ca = StructureTools.getAtomCAArray(s);
        PDBHeader header = s.getPDBHeader();
        String infoline = String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t\t%s", s.getPDBCode(), ca.length, header.getTechnique(), Float.valueOf(header.getResolution()), dateFormat.format(header.getDepDate()), dateFormat.format(header.getModDate()), header.getTitle(), header.getClassification(), Float.valueOf((float)(stopTime - startTime) / 1000.0f), path.getAbsolutePath());
        pdbWriter.println(infoline);
    }

    public File[] getAllPDB(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("path is not a directory " + dir);
        }
        String[] all = dir.list();
        ArrayList<File> pdbFiles = new ArrayList<File>();
        for (int i = 0; i < all.length; ++i) {
            String file = all[i];
            if (!file.endsWith(".pdb.gz") && !file.endsWith(".ent.gz")) continue;
            pdbFiles.add(new File(dir + File.separator + file));
        }
        return pdbFiles.toArray(new File[pdbFiles.size()]);
    }
}

