/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.io.SeqRes2AtomAligner;
import org.biojava3.alignment.Alignments;
import org.biojava3.alignment.SimpleGapPenalty;
import org.biojava3.alignment.SimpleSubstitutionMatrix;
import org.biojava3.alignment.template.AlignedSequence;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.SequencePair;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public class StructureSequenceMatcher {
    public static Structure getSubstructureMatchingProteinSequence(ProteinSequence sequence2, Structure wholeStructure) {
        ResidueNumber[] rns = StructureSequenceMatcher.matchSequenceToStructure(sequence2, wholeStructure);
        Structure structure = wholeStructure.clone();
        structure.getChains().clear();
        Chain currentChain = null;
        for (ResidueNumber rn : rns) {
            Group group;
            if (rn == null) continue;
            try {
                group = StructureTools.getGroupByPDBResidueNumber(wholeStructure, rn);
            }
            catch (StructureException e) {
                throw new IllegalArgumentException("Could not find residue " + rn + " in structure", e);
            }
            ChainImpl chain2 = new ChainImpl();
            chain2.setChainID(group.getChainId());
            if (currentChain == null || !currentChain.getChainID().equals(chain2.getChainID())) {
                structure.addChain(chain2);
                chain2.setHeader(group.getChain().getHeader());
                chain2.setParent(structure);
                chain2.setSwissprotId(group.getChain().getSwissprotId());
                chain2.setInternalChainID(group.getChain().getInternalChainID());
                chain2.setId(group.getChain().getId());
                currentChain = chain2;
            }
            currentChain.addGroup(group);
        }
        return structure;
    }

    public static ProteinSequence getProteinSequenceForStructure(Structure struct, Map<Integer, Group> groupIndexPosition) {
        if (groupIndexPosition != null) {
            groupIndexPosition.clear();
        }
        StringBuilder seqStr = new StringBuilder();
        for (Chain chain2 : struct.getChains()) {
            List<Group> groups = chain2.getAtomGroups();
            HashMap<Integer, Integer> chainIndexPosition = new HashMap<Integer, Integer>();
            int prevLen = seqStr.length();
            String chainSeq = SeqRes2AtomAligner.getFullAtomSequence(groups, chainIndexPosition);
            seqStr.append(chainSeq);
            for (Integer seqIndex : chainIndexPosition.keySet()) {
                Integer groupIndex = (Integer)chainIndexPosition.get(seqIndex);
                groupIndexPosition.put(prevLen + seqIndex, groups.get(groupIndex));
            }
        }
        return new ProteinSequence(seqStr.toString());
    }

    public static ResidueNumber[] matchSequenceToStructure(ProteinSequence seq2, Structure struct) {
        HashMap<Integer, Group> atomIndexPosition = new HashMap<Integer, Group>();
        ProteinSequence structSeq = StructureSequenceMatcher.getProteinSequenceForStructure(struct, atomIndexPosition);
        SimpleSubstitutionMatrix matrix = new SimpleSubstitutionMatrix((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet(), 1, -1);
        matrix = new SimpleSubstitutionMatrix((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet(), (Reader)new InputStreamReader(SimpleSubstitutionMatrix.class.getResourceAsStream("/blosum100.txt")), "blosum100");
        SequencePair pair2 = Alignments.getPairwiseAlignment((Sequence)seq2, (Sequence)structSeq, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)new SimpleGapPenalty(), (SubstitutionMatrix)matrix);
        AlignedSequence alignedSeq = pair2.getQuery();
        AlignedSequence alignedStruct = pair2.getTarget();
        assert (alignedSeq.getLength() == alignedStruct.getLength());
        ResidueNumber[] ca = new ResidueNumber[seq2.getLength()];
        for (int pos = alignedSeq.getStart().getPosition().intValue(); pos <= alignedSeq.getEnd().getPosition(); ++pos) {
            if (alignedSeq.isGap(pos)) {
                int structIndex = alignedStruct.getSequenceIndexAt(pos) - 1;
                assert (structIndex > 0);
                Group g = (Group)atomIndexPosition.get(structIndex);
                System.err.format("Warning: chain %s residue %s in the Structure %s has no corresponding amino acid in the sequence.\n", g.getChainId(), g.getResidueNumber().toString(), g.getChain().getParent().getPDBCode());
                continue;
            }
            if (alignedStruct.isGap(pos)) continue;
            int seqIndex = alignedSeq.getSequenceIndexAt(pos) - 1;
            int structIndex = alignedStruct.getSequenceIndexAt(pos) - 1;
            Group g = (Group)atomIndexPosition.get(structIndex);
            assert (0 <= seqIndex && seqIndex < ca.length);
            ca[seqIndex] = g.getResidueNumber();
        }
        return ca;
    }

    public static ProteinSequence removeGaps(ProteinSequence gapped) {
        int i;
        String[] gapStrings = new String[]{"-", "."};
        StringBuilder seq2 = new StringBuilder();
        CompoundSet aaSet = gapped.getCompoundSet();
        AminoAcidCompound[] gaps = new AminoAcidCompound[gapStrings.length];
        for (i = 0; i < gapStrings.length; ++i) {
            gaps[i] = (AminoAcidCompound)aaSet.getCompoundForString(gapStrings[i]);
        }
        for (i = 1; i <= gapped.getLength(); ++i) {
            AminoAcidCompound aa = (AminoAcidCompound)gapped.getCompoundAt(i);
            boolean isGap = false;
            for (AminoAcidCompound gap : gaps) {
                if (!aa.equals(gap)) continue;
                isGap = true;
                break;
            }
            if (isGap) continue;
            seq2.append(aa.getShortName());
        }
        ProteinSequence ungapped = new ProteinSequence(seq2.toString());
        return ungapped;
    }

    public static <T> T[][] removeGaps(T[][] gapped) {
        if (gapped == null) {
            return null;
        }
        if (gapped.length < 1) {
            return (Object[][])Arrays.copyOf(gapped, gapped.length);
        }
        int nProts = gapped.length;
        int protLen = gapped[0].length;
        for (int i = 0; i < nProts; ++i) {
            if (gapped[i].length == protLen) continue;
            throw new IllegalArgumentException(String.format("Expected a rectangular array, but row 0 has %d elements while row %d has %d.", protLen, i, gapped[i].length));
        }
        boolean[] isGap = new boolean[protLen];
        int gaps = 0;
        block1: for (int j = 0; j < protLen; ++j) {
            for (int i = 0; i < nProts; ++i) {
                if (gapped[i][j] != null) continue;
                isGap[j] = true;
                ++gaps;
                continue block1;
            }
        }
        Object[][] ungapped = (Object[][])Arrays.copyOf(gapped, nProts);
        int ungappedLen = protLen - gaps;
        for (int i = 0; i < nProts; ++i) {
            ungapped[i] = Arrays.copyOf(gapped[i], ungappedLen);
            int k = 0;
            for (int j = 0; j < protLen; ++j) {
                if (isGap[j]) continue;
                assert (gapped[i][j] != null);
                ungapped[i][k] = gapped[i][j];
                ++k;
            }
            assert (k == ungappedLen);
        }
        return ungapped;
    }
}

