/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.structure.align.client.FarmJobParameters;
import org.biojava.bio.structure.align.client.FarmJobRunnable;
import org.biojava.bio.structure.align.events.AlignmentProgressListener;
import org.biojava.bio.structure.align.util.CliTools;
import org.biojava.bio.structure.align.util.ConfigurationException;
import org.biojava.bio.structure.scop.CachedRemoteScopInstallation;
import org.biojava.bio.structure.scop.ScopFactory;

public class FarmJob
implements Runnable {
    private static final String[] mandParams = new String[]{"pdbFilePath"};
    private static final List<String> mandatoryArgs = Arrays.asList(mandParams);
    List<AlignmentProgressListener> progressListeners = null;
    List<FarmJobRunnable> jobs;
    FarmJobParameters params;

    public FarmJob() {
        System.setProperty("biojava.cache.files", "true");
    }

    public FarmJobParameters getParams() {
        return this.params;
    }

    public void setParams(FarmJobParameters params) {
        this.params = params;
    }

    public void addAlignmentProgressListener(AlignmentProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<AlignmentProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void clearListeners() {
        this.progressListeners.clear();
        this.progressListeners = null;
    }

    public static void main(String[] argv) {
        FarmJob job = new FarmJob();
        if (argv.length == 0) {
            job.printHelp();
            return;
        }
        if (argv.length == 1 && (argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("-help") || argv[0].equalsIgnoreCase("--help"))) {
            job.printHelp();
            return;
        }
        FarmJobParameters params = new FarmJobParameters();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            String value2 = null;
            if (i < argv.length - 1) {
                value2 = argv[i + 1];
            }
            if (value2 != null && value2.startsWith("-")) {
                value2 = null;
            } else {
                ++i;
            }
            String[] tmp = new String[]{arg, value2};
            try {
                CliTools.configureBean(params, tmp);
                continue;
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                if (!mandatoryArgs.contains(arg)) continue;
                return;
            }
        }
        if (params.getNrAlignments() == -1 && params.getTime() == -1) {
            System.err.println("Please provide either the -time or the -nrAlignments argument!");
            return;
        }
        FarmJobRunnable.log("Using parameters: " + params.toString());
        job.setParams(params);
        job.run();
    }

    @Override
    public void run() {
        String path = this.params.getPdbFilePath();
        System.setProperty("PDB_DIR", path);
        String cachePath = this.params.getCacheFilePath();
        if (cachePath != null && !cachePath.equals("")) {
            System.setProperty("PDB_CACHE_DIR", cachePath);
        } else {
            System.setProperty("PDB_CACHE_DIR", path);
        }
        CachedRemoteScopInstallation scop = new CachedRemoteScopInstallation(true);
        ScopFactory.setScopDatabase(scop);
        String username = this.params.getUsername();
        this.jobs = new ArrayList<FarmJobRunnable>();
        for (int i = 0; i < this.params.getThreads(); ++i) {
            FarmJobRunnable.log("starting thread #" + (i + 1));
            FarmJobRunnable runner = new FarmJobRunnable(this.params);
            this.params.setUsername(username + "_thread_" + (i + 1));
            this.jobs.add(runner);
            if (this.progressListeners != null) {
                for (AlignmentProgressListener li : this.progressListeners) {
                    runner.addAlignmentProgressListener(li);
                }
            }
            Thread t2 = new Thread(runner);
            if (this.params.getThreads() > 1 && i < this.params.getThreads() - 1 || this.params.isRunBackground()) {
                FarmJobRunnable.log("starting thread " + (i + 1) + " in background.");
                t2.start();
                continue;
            }
            FarmJobRunnable.log("starting thread " + (i + 1) + " in main thread.");
            t2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        FarmJobRunnable.log("terminating jobs:");
        if (this.jobs == null) {
            return;
        }
        int js = this.jobs.size();
        FarmJobRunnable.log("nr jobs: " + js);
        Iterator<FarmJobRunnable> i$ = this.jobs.iterator();
        while (i$.hasNext()) {
            FarmJobRunnable runner;
            FarmJobRunnable farmJobRunnable = runner = i$.next();
            synchronized (farmJobRunnable) {
                runner.terminate();
            }
        }
        this.clearListeners();
    }

    public void printHelp() {
        System.out.println("-------------------");
        System.out.println("FarmJob help:");
        System.out.println("-------------------");
        System.out.println("FarmJob accepts the following parameters:");
        System.out.println("");
        System.out.println(" Mandatory:");
        System.out.println("   -pdbFilePath (mandatory) Path to the directory in your file system that contains the PDB files.");
        System.out.println("   provide either -time or -nrAlignments. If both are provided the job stops as soon as any of the criteria has been reached.");
        System.out.println("   -time maximum number of time to run (in seconds). -1 means no time limit, but run -nrAlignment arguments. Default: -1");
        System.out.println("   -nrAlignments number of alignments to calculate. Default: -1");
        System.out.println("");
        System.out.println(" Optional: ");
        System.out.println("   -threads number of parallel threads to calculate alignments. Should be nr. of available CPUs. Default: 1");
        System.out.println("   -server the location of the server URL to talk to. Default : " + FarmJobParameters.DEFAULT_SERVER_URL);
        System.out.println("   -pdbDirSplit true/false the directory containing PDB files has all PDBs in one level or is split into multiple subdirs, like the ftp site. Default: true");
        System.out.println("   -username a unique name that can be given to this client. Can be used to give credit for who is doing the calculations. Default: IP and a random id");
        System.out.println("   -stepSize the number of pairs to be requsted from server. Default: 100");
    }
}

