/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.biojava.bio.structure.PDBRecord;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;

public class PDBHeader
implements PDBRecord,
Serializable {
    private static final long serialVersionUID = -5834326174085429508L;
    String method;
    String title;
    String description;
    String idCode;
    String classification;
    Date depDate = new Date(0L);
    Date modDate = new Date(0L);
    String technique;
    float resolution = 99.0f;
    String authors;
    int nrBioAssemblies = -1;
    public static final float DEFAULT_RESOLUTION = 99.0f;
    private Long id;
    public static final String newline = System.getProperty("line.separator");
    DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy", Locale.US);
    Map<Integer, List<ModelTransformationMatrix>> tranformationMap = new HashMap<Integer, List<ModelTransformationMatrix>>();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            Class<?> c = Class.forName("org.biojava.bio.structure.PDBHeader");
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Object o;
                Method m = methods[i];
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass") || (o = m.invoke((Object)this, new Object[0])) == null) continue;
                buf.append(name.substring(3, name.length()));
                buf.append(": " + o + " ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    @Override
    public String toPDB() {
        StringBuffer buf = new StringBuffer();
        this.toPDB(buf);
        return buf.toString();
    }

    @Override
    public void toPDB(StringBuffer buf) {
        this.printHeader(buf);
        this.printTitle(buf);
        this.printExpdata(buf);
        this.printAuthors(buf);
        this.printResolution(buf);
    }

    private void printResolution(StringBuffer buf) {
        if (this.getResolution() == 99.0f) {
            return;
        }
        DecimalFormat d2 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d2.setMaximumIntegerDigits(2);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        buf.append("REMARK   2 RESOLUTION. ");
        String x2 = d2.format(this.resolution);
        buf.append(x2);
        buf.append(" ANGSTROMS.");
        this.fillLine(buf, 34 + x2.length());
        buf.append(newline);
    }

    private void printExpdata(StringBuffer buf) {
        String exp = this.getTechnique();
        if (exp == null || exp.length() == 0) {
            return;
        }
        buf.append("EXPDTA    ");
        buf.append(exp);
        int l = exp.length() + 10;
        this.fillLine(buf, l);
        buf.append(newline);
    }

    private void printAuthors(StringBuffer buf) {
        String authors = this.getAuthors();
        if (authors == null) {
            return;
        }
        if (authors.equals("")) {
            return;
        }
        this.printMultiLine(buf, "AUTHOR   ", authors, ',');
    }

    private void printMultiLine(StringBuffer buf, String lineStart, String data2, char breakChar) {
        int l;
        if (lineStart.length() != 9) {
            System.err.println("lineStart != 9, there will be problems :" + lineStart);
        }
        if (data2.length() < 58) {
            buf.append(lineStart);
            buf.append(" ");
            buf.append(data2);
            buf.append(newline);
            return;
        }
        String thisLine = "";
        int count2 = 1;
        while (data2.length() > 57) {
            boolean charFound = false;
            for (int i = 57; i > -1; --i) {
                char c = data2.charAt(i);
                if (c != breakChar) continue;
                thisLine = data2.substring(0, i + 1);
                if (i == 0) {
                    ++i;
                }
                data2 = data2.substring(i);
                charFound = true;
                break;
            }
            if (!charFound) {
                thisLine = data2.substring(0, 58);
                data2 = data2.substring(57);
            }
            if (breakChar == ',' && data2.charAt(0) == ',') {
                data2 = data2.substring(1);
            }
            buf.append(lineStart);
            if (count2 > 1) {
                buf.append(count2);
                if (breakChar != ' ') {
                    buf.append(" ");
                }
            } else {
                buf.append(" ");
            }
            buf.append(thisLine);
            for (l = thisLine.length() + 10; l < 67; ++l) {
                buf.append(" ");
            }
            buf.append(newline);
            ++count2;
        }
        if (data2.trim().length() > 0) {
            buf.append(lineStart);
            buf.append(count2);
            int filledLeft = 10;
            if (breakChar != ' ') {
                buf.append(" ");
                ++filledLeft;
            }
            buf.append(data2);
            l = data2.length() + filledLeft;
            this.fillLine(buf, l);
            buf.append(newline);
        }
    }

    private void fillLine(StringBuffer buf, int currentPos) {
        for (int l = currentPos; l < 67; ++l) {
            buf.append(" ");
        }
    }

    private void printHeader(StringBuffer buf) {
        String classification = this.getClassification();
        if (classification == null || classification.length() == 0) {
            return;
        }
        buf.append("HEADER    ");
        buf.append(classification);
        buf.append(" ");
        for (int l = classification.length() + 10; l < 49; ++l) {
            buf.append(" ");
        }
        Date d = this.getDepDate();
        if (d != null) {
            buf.append(this.dateFormat.format(d));
        } else {
            buf.append("         ");
        }
        buf.append("   ");
        String id = this.getIdCode();
        if (id != null) {
            buf.append(this.getIdCode());
            buf.append(" ");
        } else {
            buf.append("    ");
        }
        buf.append(newline);
    }

    private void printTitle(StringBuffer buf) {
        String title = this.getTitle();
        if (title == null || title.trim().length() == 0) {
            return;
        }
        this.printMultiLine(buf, "TITLE    ", title, ' ');
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public boolean equals(PDBHeader other) {
        try {
            Class<?> c = Class.forName("org.biojava.bio.structure.PDBHeader");
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass")) continue;
                Object a = m.invoke((Object)this, new Object[0]);
                Object b = m.invoke((Object)other, new Object[0]);
                if (a == null) {
                    if (b == null) continue;
                    System.out.println(name + " a is null, where other is " + b);
                    return false;
                }
                if (b == null) {
                    System.out.println(name + " other is null, where a is " + a);
                    return false;
                }
                if (a.equals(b)) continue;
                System.out.println("mismatch with " + name + " >" + a + "< >" + b + "<");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getIdCode() {
        return this.idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public void setDepDate(Date depDate) {
        this.depDate = depDate;
    }

    public String getTechnique() {
        return this.technique;
    }

    public void setTechnique(String technique) {
        this.technique = technique;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public Map<Integer, List<ModelTransformationMatrix>> getBioUnitTranformationMap() {
        return this.tranformationMap;
    }

    public void setBioUnitTranformationMap(Map<Integer, List<ModelTransformationMatrix>> tranformationMap) {
        this.tranformationMap = tranformationMap;
    }

    public void setNrBioAssemblies(int nrBioAssemblies) {
        this.nrBioAssemblies = nrBioAssemblies;
    }

    public int getNrBioAssemblies() {
        return this.nrBioAssemblies;
    }
}

