/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.commandLine;

import com.clineff.Workflow;
import com.clineff.license.License;
import com.clineff.report.VcfReport;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.logStatsServer.LogStats;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.VcfAnnotator;
import org.snpeff.snpEffect.VcfAnnotatorChain;
import org.snpeff.snpEffect.commandLine.CommandLine;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdAnnotate;
import org.snpsift.SnpSiftCmdFilter;

public class ClinEff
implements CommandLine,
VcfAnnotator {
    public static final String[] VCF_EXTS = new String[]{".gz", ".vcf"};
    public static final String DEFAULT_CONFIG_FILE = "clinEff.config";
    public static final String DEFAULT_LICENSE_FILE = "clinEff.license";
    public static final String BUILD = SnpEff.BUILD;
    public static final String SOFTWARE_NAME = "ClinEff";
    public static final String VERSION_MAJOR = "1.0";
    public static final String REVISION = "h";
    public static final String VERSION_SHORT = "1.0h";
    public static final String VERSION_BUILD = "1.0h (build " + BUILD + ")";
    public static final String VERSION_AUTHOR = String.valueOf(VERSION_BUILD) + ", by " + "Pablo Cingolani";
    public static final String VERSION_FULL = "ClinEff " + VERSION_AUTHOR;
    public static final String LICENSE_URL = "http://www.dnaminer.com/clineff.html#license";
    protected List<VcfAnnotator> annotationModules;
    protected List<VcfAnnotator> annotationFilters;
    protected String[] args;
    protected Config config;
    protected String configFile = "clinEff.config";
    protected Map<String, String> configOverride = new HashMap<String, String>();
    protected String dataDir;
    protected boolean debug = false;
    protected License license;
    protected boolean licenseCheck = false;
    protected boolean licenseCreate = false;
    protected String licenseFile = "clinEff.license";
    protected String licenseKeyDir;
    protected String licensedTo;
    protected License.LicenseType licenseType;
    protected boolean log = true;
    protected String genomeVer;
    protected StringBuilder output = new StringBuilder();
    protected List<VcfReport> reporterModules;
    protected List<VcfEntry> results;
    protected List<String> sampleNames;
    protected boolean saveOutput = false;
    protected boolean saveResults = false;
    protected boolean skipSnpEff = false;
    protected SnpEffCmdEff snpEffCmdEff;
    protected boolean suppressOutput = false;
    protected boolean suppressReports = false;
    protected VcfAnnotatorChain vcfAnnotatorChain;
    protected List<String> vcfDbFiles;
    protected String vcfFileName;
    protected boolean verbose = false;
    protected String workflowFile = "workflow.config";
    protected Workflow workflow;

    public static void main(String[] args) {
        ClinEff clinEff = new ClinEff(args);
        boolean ok = clinEff.run();
        System.exit(ok ? 0 : -1);
    }

    public ClinEff(String[] args) {
        this.args = args;
        this.vcfDbFiles = new LinkedList<String>();
    }

    @Override
    public boolean addHeaders(VcfFileIterator vcfFile) {
        for (VcfHeaderEntry hinf : this.headers()) {
            vcfFile.getVcfHeader().add(hinf);
        }
        return this.vcfAnnotatorChain.addHeaders(vcfFile);
    }

    protected void annotate() {
        if (this.verbose) {
            Timer.showStdErr("Annotating input file '" + this.vcfFileName + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFileName, this.config.getGenome());
        this.annotateInit(vcf);
        this.reportInit(vcf);
        int pos = -1;
        String chr = "";
        boolean header = false;
        for (VcfEntry vcfEntry : vcf) {
            if (vcf.isHeadeSection()) {
                this.processVcfHeader(vcf);
                this.sampleNames = vcf.getVcfHeader().getSampleNames();
                if (this.sampleNames == null) {
                    this.fatalError("VCF file '" + this.vcfFileName + "' does not have any sample. Missing '#CHROM' header line?");
                }
                if (this.verbose) {
                    Timer.showStdErr("Samples in VCF file: " + this.sampleNames.size());
                    for (String sn : this.sampleNames) {
                        System.err.println("\t" + sn);
                    }
                }
                header = true;
            }
            if (vcfEntry.getChromosomeName().equals(chr) && vcfEntry.getStart() < pos) {
                this.fatalError("Your VCF file should be sorted!\n\tPrevious entry " + chr + ":" + pos + "\n\tCurrent entry  " + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1));
            }
            this.annotate(vcfEntry);
            this.report(vcfEntry);
            if (this.saveResults) {
                this.results.add(vcfEntry);
            }
            chr = vcfEntry.getChromosomeName();
            pos = vcfEntry.getStart();
        }
        if (!header) {
            this.processVcfHeader(vcf);
        }
        this.annotateFinish(vcf);
        this.reportFinish();
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        boolean annotated = this.vcfAnnotatorChain.annotate(vcfEntry);
        this.print(vcfEntry);
        return annotated;
    }

    @Override
    public boolean annotateFinish(VcfFileIterator vcf) {
        return this.vcfAnnotatorChain.annotateFinish(vcf);
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        return this.vcfAnnotatorChain.annotateInit(vcfFile);
    }

    void checkLicense() {
        String licFile;
        this.license = new License();
        this.license.setVerbose(this.verbose);
        boolean ok = this.license.checkLicense(this.licenseFile);
        if (ok) {
            return;
        }
        File lf = new File(this.licenseFile);
        if (!lf.isAbsolute() && (ok = this.license.checkLicense(licFile = String.valueOf(this.config.getDirMain()) + "/" + this.licenseFile))) {
            return;
        }
        if (!ok) {
            this.usage("Could not check license file '" + this.licenseFile + "'\n" + "If you don't hava a ClinEff license, you can get one here: " + LICENSE_URL + "\n\n");
        }
    }

    protected String commandLineStr() {
        if (this.args == null) {
            return "";
        }
        StringBuilder argsList = new StringBuilder();
        argsList.append("ClinEff ");
        if (this.args != null) {
            String[] stringArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if ((arg = arg.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim()).indexOf(32) > 0) {
                    arg = "'" + arg + "'";
                }
                argsList.append(String.valueOf(arg) + " ");
                ++n2;
            }
        }
        return argsList.toString().trim();
    }

    String commandLineStr(boolean splitLines) {
        StringBuilder argsList = new StringBuilder();
        argsList.append("ClinEff ");
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            argsList.append(String.valueOf(arg.trim()) + " ");
            ++n2;
        }
        return argsList.toString().trim();
    }

    public VcfAnnotatorChain createAnnotatorChain() {
        VcfAnnotatorChain vcfAnnotatorChain = new VcfAnnotatorChain();
        if (!this.skipSnpEff) {
            vcfAnnotatorChain.add(this.snpEffCmdEff);
        }
        for (String db : this.vcfDbFiles) {
            SnpSift snpSift = new SnpSift();
            snpSift.setCommand(SnpSiftCmdAnnotate.class);
            snpSift.setShowVersion(false);
            snpSift.setVerbose(this.verbose);
            snpSift.setDebug(this.debug);
            snpSift.setConfig(this.config);
            snpSift.setSuppressOutput(true);
            snpSift.setShowVcfHeader(false);
            snpSift.setVcfHeaderAddProgramVersion(false);
            SnpSiftCmdAnnotate snpSiftAnn = (SnpSiftCmdAnnotate)snpSift.cmd();
            snpSiftAnn.setDbFileName(db);
            snpSiftAnn.setAnnotateEmpty(false);
            vcfAnnotatorChain.add(snpSiftAnn);
        }
        for (VcfAnnotator ann : this.annotationModules) {
            vcfAnnotatorChain.add(ann);
        }
        for (VcfAnnotator ann : this.annotationFilters) {
            vcfAnnotatorChain.add(ann);
        }
        vcfAnnotatorChain.setConfig(this.config);
        vcfAnnotatorChain.setVerbose(this.verbose);
        vcfAnnotatorChain.setDebug(this.debug);
        return vcfAnnotatorChain;
    }

    void createlicense() {
        Calendar gc = Calendar.getInstance();
        gc.add(1, 1);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String licenseExpires = sf.format(gc.getTime());
        String pubKeyFile = String.valueOf(this.licenseKeyDir) + "/key_public.key";
        String privKeyFile = String.valueOf(this.licenseKeyDir) + "/key_private.key";
        License rsa = null;
        String licenseNumber = "";
        Random rand = new Random();
        int i = 0;
        while (i < 2) {
            licenseNumber = String.valueOf(licenseNumber) + Integer.toHexString(rand.nextInt());
            ++i;
        }
        String txt = "license_to      : " + this.licensedTo + "\n" + "license_expires : " + licenseExpires + "\n" + "license_type    : " + (Object)((Object)this.licenseType) + "\n" + "license_version : " + "20161210" + "\n" + "license_number  : " + licenseNumber + "\n";
        System.out.println("Creating license file: " + this.licenseFile);
        Gpr.toFile(this.licenseFile, txt);
        System.out.println("Signing license");
        System.out.println("Reading file: " + this.licenseFile);
        String originalTxt = Gpr.readFile(this.licenseFile);
        System.out.println("Original text:\n" + originalTxt + "\n");
        rsa = new License(privKeyFile, pubKeyFile);
        String signature = rsa.sign(originalTxt);
        System.out.println("Signature:\n----------\n" + signature + "\n----------\n");
        String signFile = String.valueOf(this.licenseFile) + ".sign";
        Gpr.toFile(signFile, signature);
        System.out.println("Signature saved to file '" + signFile + "'");
        rsa = new License();
        boolean ok = rsa.checkLicense(this.licenseFile);
        if (!ok) {
            throw new RuntimeException("Signature does not match!");
        }
        System.out.println("Checking signature: " + ok);
    }

    protected void createReport() {
        if (this.suppressReports) {
            return;
        }
        String base = Gpr.baseName(this.vcfFileName);
        String[] stringArray = VCF_EXTS;
        int n = VCF_EXTS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            base = Gpr.baseName(base, ext);
            ++n2;
        }
        String pathBase = String.valueOf(Gpr.dirName(this.vcfFileName)) + "/" + base;
        for (VcfReport reporter : this.reporterModules) {
            String reportName = reporter.getClass().getSimpleName();
            if (this.sampleNames != null && !this.sampleNames.isEmpty()) {
                for (String sampleName : this.sampleNames) {
                    String outputFile = String.valueOf(pathBase) + "." + sampleName + "." + reportName;
                    reporter.createReport(outputFile, sampleName);
                }
                continue;
            }
            String outputFile = String.valueOf(pathBase) + "." + reportName;
            reporter.createReport(outputFile, null);
        }
    }

    public void error(Throwable e, String message) {
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        System.err.println("Error: " + message);
    }

    public void fatalError(String message) {
        System.err.println("Fatal error: " + message);
        System.exit(-1);
    }

    public void fatalError(Throwable e, String message) {
        System.err.println("Fatal error: " + message);
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public List<VcfEntry> getResults() {
        return this.results;
    }

    protected List<VcfHeaderEntry> headers() {
        ArrayList<VcfHeaderEntry> newHeaders = new ArrayList<VcfHeaderEntry>();
        newHeaders.add(new VcfHeaderEntry("##ClinEffVersion=\"" + VERSION_AUTHOR + "\""));
        newHeaders.add(new VcfHeaderEntry("##ClinEffCmd=\"" + this.commandLineStr() + "\""));
        return newHeaders;
    }

    void init() {
        this.config = new Config(this.genomeVer, this.configFile, this.dataDir, this.configOverride, this.verbose);
        this.config.setDebug(this.debug);
        this.workflow = new Workflow(this.workflowFile, this.config, this.verbose);
        this.workflow.setDebug(this.debug);
        this.initAnotators();
        this.reporterModules = this.workflow.modulesReport();
        this.vcfAnnotatorChain = this.createAnnotatorChain();
        this.results = new LinkedList<VcfEntry>();
    }

    protected void initAnotators() {
        String dbDir = this.config.getDirMain();
        for (String dbVcf : this.workflow.getAnnotaionDbsVcf()) {
            if (!Gpr.exists(dbVcf) && Gpr.exists(String.valueOf(dbDir) + "/" + dbVcf)) {
                dbVcf = String.valueOf(dbDir) + "/" + dbVcf;
            }
            if (!Gpr.exists(dbVcf)) {
                this.fatalError("Cannot find file '" + dbVcf + "', referenced in workflow file '" + this.workflowFile + "' entry '" + "annotation.db.vcf" + "'.");
            }
            if (this.verbose) {
                Timer.showStdErr("Adding annotation database (VCF): '" + dbVcf + "'");
            }
            this.vcfDbFiles.add(dbVcf);
        }
        this.annotationModules = this.workflow.modulesAnnotation();
        this.annotationFilters = new LinkedList<VcfAnnotator>();
        for (String filterName : this.workflow.getFilters()) {
            if (filterName.isEmpty()) continue;
            String workflowEntry = "filter." + filterName;
            String filterExpr = this.workflow.getString(workflowEntry);
            if (filterExpr == null || filterExpr.trim().isEmpty()) {
                this.fatalError("Filter entry '" + workflowEntry + "' not found in workflow file '" + this.workflowFile + "'");
            }
            filterExpr = filterExpr.trim();
            if (this.verbose) {
                Timer.showStdErr("Adding filter '" + filterName + "': " + filterExpr);
            }
            SnpSiftCmdFilter filter2 = new SnpSiftCmdFilter();
            filter2.setConfig(this.config);
            filter2.setVerbose(this.verbose);
            filter2.setDebug(this.debug);
            filter2.setExpression(filterExpr);
            filter2.setFilterId(filterName);
            filter2.setAddFilterField(filterName);
            filter2.setShowVcfHeader(false);
            filter2.setVcfHeaderAddProgramVersion(false);
            this.annotationFilters.add(filter2);
        }
        if (!Gpr.canRead(this.vcfFileName)) {
            this.usage("Cannot read input file '" + this.vcfFileName + "'");
        }
        this.initSnpEff();
    }

    protected SnpEffCmdEff initSnpEff() {
        if (this.verbose) {
            Timer.showStdErr("Adding SnpEff annotations");
        }
        SnpEff snpEff = new SnpEff();
        snpEff.setVerbose(this.verbose);
        snpEff.setDebug(this.debug);
        snpEff.setGenomeVer(this.genomeVer);
        snpEff.setConfigFile(this.configFile);
        snpEff.setConfig(this.config);
        snpEff.setLog(false);
        this.workflow.configArguments("ann", snpEff);
        this.snpEffCmdEff = (SnpEffCmdEff)snpEff.cmd();
        this.snpEffCmdEff.setSupressOutput(true);
        return this.snpEffCmdEff;
    }

    protected boolean isOpt(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    protected void load() {
        if (!this.skipSnpEff) {
            this.snpEffCmdEff.load();
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        int i = 0;
        while (i < args.length) {
            block97: {
                String arg;
                block95: {
                    arg = args[i];
                    if (!this.isOpt(arg)) break block95;
                    switch (arg.toLowerCase()) {
                        case "-config": 
                        case "-c": {
                            if (i + 1 < args.length) {
                                this.configFile = args[++i];
                                break;
                            }
                            this.usage("Option '-c' without config file argument");
                            break;
                        }
                        case "-configoption": {
                            if (i + 1 < args.length) {
                                String nameValue;
                                String[] nv;
                                if ((nv = (nameValue = args[++i]).split("=", 2)).length > 0) {
                                    this.configOverride.put(nv[0], nv[1]);
                                    break;
                                }
                                this.usage("Cannot parse config option (expected format 'name=value'): " + nameValue);
                                break;
                            }
                            this.usage("Option '-configOption' without argument");
                            break;
                        }
                        case "-d": 
                        case "-debug": {
                            this.verbose = true;
                            this.debug = true;
                            break;
                        }
                        case "-datadir": {
                            if (i + 1 < args.length) {
                                this.dataDir = args[++i];
                                break;
                            }
                            this.usage("Option '-dataDir' without data_dir argument");
                            break;
                        }
                        case "-db": {
                            if (i + 1 < args.length) {
                                this.vcfDbFiles.add(args[++i]);
                                break;
                            }
                            this.usage("Option '-db' without file.vcf argument");
                            break;
                        }
                        case "-h": 
                        case "-help": {
                            this.usage(null);
                            break;
                        }
                        case "-l": 
                        case "-license": {
                            if (i + 1 < args.length) {
                                this.licenseFile = args[++i];
                                break;
                            }
                            this.usage("Option '-l' without lincese file argument");
                            break;
                        }
                        case "-licensecheck": {
                            this.licenseCheck = true;
                            break;
                        }
                        case "-licensecreate": {
                            this.licenseCreate = true;
                            break;
                        }
                        case "-licensekeydir": {
                            if (i + 1 < args.length) {
                                this.licenseKeyDir = args[++i];
                                break;
                            }
                            this.usage("Option '-licenseKeyDir' without lincese key dir argument");
                            break;
                        }
                        case "-licenseto": {
                            if (i + 1 < args.length) {
                                this.licensedTo = args[++i];
                                break;
                            }
                            this.usage("Option '-licenseTo' without lincese type argument");
                            break;
                        }
                        case "-licensetype": {
                            if (i + 1 < args.length) {
                                this.licenseType = License.LicenseType.valueOf(args[++i]);
                                break;
                            }
                            this.usage("Option '-licenseType' without lincese type argument");
                            break;
                        }
                        case "-noeff": {
                            this.skipSnpEff = true;
                            break;
                        }
                        case "-noout": {
                            this.suppressOutput = true;
                            break;
                        }
                        case "-noreport": {
                            this.suppressReports = true;
                            break;
                        }
                        case "-v": 
                        case "-verbose": {
                            this.verbose = true;
                            break;
                        }
                        case "-version": {
                            System.out.println(VERSION_SHORT);
                            System.exit(0);
                            break;
                        }
                        case "-w": 
                        case "-workflow": {
                            if (i + 1 < args.length) {
                                this.workflowFile = args[++i];
                                break;
                            }
                            this.usage("Option '-w' without workflow file argument");
                            break;
                        }
                        default: {
                            this.usage("Unrecognized option '" + arg + "'");
                            break;
                        }
                    }
                    break block97;
                }
                if (this.genomeVer == null) {
                    this.genomeVer = arg;
                } else if (this.vcfFileName == null) {
                    this.vcfFileName = arg;
                }
            }
            ++i;
        }
        if (this.licenseCheck) {
            if (this.licenseFile == null) {
                this.fatalError("Missing license file argument '-lincese'");
            }
            return;
        }
        if (this.licenseCreate) {
            if (this.licenseFile == null) {
                this.fatalError("Missing license file argument '-lincese'");
            }
            if (this.licenseKeyDir == null) {
                this.fatalError("Missing license key dir argument '-linceseKeyDir'");
            }
            if (this.licensedTo == null) {
                this.fatalError("Missing 'licensed to' argument '-linceseTo'");
            }
            if (this.licenseType == null) {
                this.fatalError("Missing license type argument '-linceseType'");
            }
            return;
        }
        if (this.genomeVer == null) {
            this.fatalError("Missing genome version argument");
        }
        if (this.vcfFileName == null) {
            this.vcfFileName = "-";
            if (this.verbose) {
                Timer.showStdErr("No input file specified, using STDIN");
            }
        }
    }

    void print(Object o) {
        if (this.saveOutput) {
            this.output.append(String.valueOf(o.toString()) + "\n");
        } else if (!this.suppressOutput) {
            System.out.println(o.toString());
        }
    }

    protected String processVcfHeader(VcfFileIterator vcf) {
        if (!vcf.isHeadeSection() && vcf.getLineNum() > 1) {
            return "";
        }
        this.addHeaders(vcf);
        String headerStr = vcf.getVcfHeader().toString();
        if (!headerStr.isEmpty()) {
            this.print(headerStr);
        }
        return headerStr;
    }

    protected void report(VcfEntry vcfEntry) {
        for (VcfReport vrep : this.reporterModules) {
            vrep.report(vcfEntry);
        }
    }

    public boolean reportFinish() {
        boolean ok = false;
        for (VcfReport vrep : this.reporterModules) {
            ok |= vrep.reportFinish();
        }
        return ok;
    }

    public boolean reportInit(VcfFileIterator vcfFile) {
        boolean ok = false;
        for (VcfReport vrep : this.reporterModules) {
            ok |= vrep.reportInit(vcfFile);
        }
        return ok;
    }

    public HashMap<String, String> reportValues() {
        Properties licProps;
        HashMap<String, String> reportValues = this.snpEffCmdEff.reportValues();
        if (this.sampleNames != null) {
            reportValues.put("numberOfSamples", "" + this.sampleNames.size());
        }
        if ((licProps = this.license.getProperties()) != null) {
            for (Object k : licProps.keySet()) {
                String val = licProps.getProperty(k.toString());
                if (val == null) continue;
                reportValues.put(k.toString(), val.toString());
            }
        }
        return reportValues;
    }

    @Override
    public boolean run() {
        StringBuilder err2;
        boolean ok;
        block9: {
            block8: {
                ok = true;
                err2 = new StringBuilder();
                this.parseArgs(this.args);
                if (this.verbose) {
                    System.err.println("ClinEff version " + VERSION_FULL);
                }
                if (!this.licenseCheck) break block8;
                this.checkLicense();
                return true;
            }
            if (!this.licenseCreate) break block9;
            this.createlicense();
            return true;
        }
        try {
            this.init();
            this.checkLicense();
            this.load();
            this.annotate();
            this.createReport();
        }
        catch (Throwable t2) {
            ok = false;
            if (err2 != null) {
                err2.append(t2.getMessage());
            }
            t2.printStackTrace();
        }
        if (this.log) {
            LogStats.report(SOFTWARE_NAME, VERSION_SHORT, VERSION_BUILD, ok, this.verbose, this.args, err2.toString(), this.reportValues());
        }
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        return ok;
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
        this.vcfAnnotatorChain.setConfig(config);
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
        this.vcfAnnotatorChain.setDebug(debug);
    }

    public void setLog(boolean log2) {
        this.log = log2;
    }

    public void setSaveOutput(boolean saveOutput) {
        this.saveOutput = saveOutput;
    }

    public void setSaveResults(boolean saveResults) {
        this.saveResults = saveResults;
    }

    public void setSuppressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public void setSuppressReports(boolean suppressReports) {
        this.suppressReports = suppressReports;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.vcfAnnotatorChain != null) {
            this.vcfAnnotatorChain.setVerbose(verbose);
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("ClinEff version " + VERSION_FULL);
        System.err.println("Usage: ClinEff [command] [options] genome [file.vcf]");
        System.err.println("\nAvailable command line options: ");
        System.err.println("\t-c , -config <file>          : Specify config file. Default: clinEff.config");
        System.err.println("\t-db <file.vcf>               : Add annotations from database 'file.vcf'");
        System.err.println("\t-d , -debug                  : Debug mode (very verbose)");
        System.err.println("\t-h , -help                   : Show this help and exit");
        System.err.println("\t-l , -license <file>         : Path to lincese files");
        System.err.println("\t-v , -verbose                : Verbose mode");
        System.err.println("\t-version                     : Show version number and exit");
        System.err.println("\t-w , -workflow <file>        : Workflow file. Default: workflow.config");
        System.exit(-1);
    }
}

