/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.xch;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.xch.XchAaddress;
import edsim51sh.instructions.xch.XchAatReg;
import edsim51sh.instructions.xch.XchAreg;
import edsim51sh.instructions.xch.XchdAatReg;

public class Xch
extends Instruction {
    public Xch() {
        this.mneumonic = "XCH";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("XCH A,")) {
            int registerNumber;
            if (mneumonic.length() == 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("XCH A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new XchAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("XCH A,@R0") || mneumonic.equals("XCH A,@R1")) {
                    return new XchAatReg(registerNumber);
                }
            }
            return new XchAaddress();
        }
        if (mneumonic.length() >= 10) {
            int registerNumber = mneumonic.charAt(9) - 48;
            if (mneumonic.equals("XCHD A,@R0") || mneumonic.equals("XCHD A,@R1")) {
                return new XchdAatReg(registerNumber);
            }
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

