/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.gui;

import edsim51sh.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTextField;

class MemoryWindowBox
extends JTextField {
    static final int DATA = 0;
    static final int COL_HEADING = 1;
    static final int ROW_HEADING = 2;
    static final Font SMALL_FONT = new Font("Monospaced", 0, 12);
    static final Font LARGE_FONT = new Font("Monospaced", 0, 18);
    static final Font SMALL_BOLD_FONT = new Font("Monospaced", 0, 12);
    static final Font LARGE_BOLD_FONT = new Font("Monospaced", 0, 18);
    static final Dimension SMALL_DIMENSION = new Dimension(20, 16);
    static final Dimension LARGE_DIMENSION = new Dimension(30, 24);
    static final Dimension SMALL_DOUBLE_WIDTH_DIMENSION = new Dimension(40, 16);
    static final Dimension LARGE_DOUBLE_WIDTH_DIMENSION = new Dimension(60, 24);
    static final Color BLACK = new Color(51, 51, 51);
    static final Color GREY = new Color(238, 238, 238);
    static final Color BLUE = new Color(180, 180, 255);
    int data = -1;
    int type;
    boolean backgroundIsBlue = false;
    private boolean dataMemory = true;
    private boolean isRed = false;

    MemoryWindowBox(int i, boolean size, int type, boolean dataMemory) {
        this.type = type;
        this.setEditable(false);
        if (type == 2) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(0);
        }
        this.makeSmall(size, type);
        this.setData(i, dataMemory);
    }

    void makeSmall(boolean b, int type) {
        if (b) {
            this.setMaximumSize(SMALL_DIMENSION);
            this.setMinimumSize(SMALL_DIMENSION);
            this.setPreferredSize(SMALL_DIMENSION);
            this.setFont(SMALL_BOLD_FONT);
        } else {
            this.setMaximumSize(LARGE_DIMENSION);
            this.setMinimumSize(LARGE_DIMENSION);
            this.setPreferredSize(LARGE_DIMENSION);
            this.setFont(LARGE_BOLD_FONT);
        }
    }

    void setData(int i, boolean dataMemory) {
        if (dataMemory) {
            if (this.backgroundIsBlue) {
                this.backgroundIsBlue = false;
                this.setBackground(GREY);
            }
        } else if (!this.backgroundIsBlue) {
            this.backgroundIsBlue = true;
            this.setBackground(BLUE);
        }
        if (i != this.data) {
            this.data = i;
            int numberOfDigits = 2;
            if (this.type == 1) {
                numberOfDigits = 1;
            } else if (i > 256) {
                numberOfDigits = 4;
            }
            this.setText(Text.inHex(i, false, numberOfDigits, false));
        }
        this.dataMemory = dataMemory;
    }

    private Color getNewForegroundColor(int i, boolean dataMemory) {
        if (this.switchingMemoryType(dataMemory)) {
            this.isRed = false;
            return BLACK;
        }
        if (i != this.data && this.data != -1) {
            if (this.isRed) {
                return null;
            }
            this.isRed = true;
            return Color.RED;
        }
        if (i == this.data) {
            if (this.isRed) {
                this.isRed = false;
                return BLACK;
            }
            return null;
        }
        return null;
    }

    private boolean switchingMemoryType(boolean dataMemory) {
        return dataMemory && !this.dataMemory && !dataMemory && this.dataMemory;
    }
}

